% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoom.R
\name{zoom}
\alias{zoom}
\alias{zoom.trellis}
\title{Zoom}
\usage{
zoom(x, ...)

\method{zoom}{trellis}(x, size = 1, main = 1.2 * size, lab = size,
  axis = size, strip = size, sub = 0.9 * size, legend = 0.9 * size,
  splom = 0.9 * size, ...)
}
\arguments{
\item{x}{a lattice plot of class \code{"trellis"}.}

\item{\dots}{further arguments, currently ignored.}

\item{size}{text size multiplier.}

\item{main}{size of main title (default is \code{1.2 * size}).}

\item{lab}{size of axis labels (default is \code{size}).}

\item{axis}{size of tick labels (default is \code{size}).}

\item{strip}{size of strip labels (default is \code{size}).}

\item{sub}{size of subtitle (default is \code{0.9 * size}).}

\item{legend}{size of legend labels (default is \code{0.9 * size}).}

\item{splom}{size of scatterplot matrix diagonal labels (default is
\code{0.9 * size}).}
}
\value{
The same lattice object, but with altered text size.
}
\description{
Change text size in a lattice plot.
}
\details{
Pass \code{NULL} for any argument to avoid changing the size of that text
component.

The \code{legend} component of a lattice plot can be somewhat fickle, as the
object structure varies between plots. One solution is to pass
\code{legend = NULL} and tweak the legend before or after calling the
\code{zoom} function.
}
\note{
The default values result in lattice plots that have similar text size as
base plots, when using \code{taf.png}.

This function ends with a \code{\link[=print.trellis]{print}} call, to make
it easy to export the lattice plot to a file, without the need of an explicit
\code{print}.
}
\examples{
library(lattice)

xyplot(1~1)
zoom(xyplot(1~1))
zoom(xyplot(1~1), size=1.2)
zoom(xyplot(1~1), axis=0.8)
zoom(xyplot(1~1), axis=NULL)

\dontrun{
taf.png("myplot")
plot(1)
dev.off()

taf.png("mytrellis")
xyplot(1~1)
dev.off()

taf.png("mytrellis_zoom")
zoom(xyplot(1~1))
dev.off()
}

}
\seealso{
\code{\link{Lattice}} plots are created using \code{\link{xyplot}} or related
functions.

\code{\link{taf.png}} opens a PNG graphics device.

\code{\link{TAF-package}} gives an overview of the package.
}
