% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taf.data.path.R
\name{taf.data.path}
\alias{taf.data.path}
\title{Construct Boot Data Path}
\usage{
taf.data.path(..., fsep = .Platform$file.sep)
}
\arguments{
\item{...}{filenames inside \code{bootstrap/data}.}

\item{fsep}{path separator to use instead of the default forward slash.}
}
\value{
Relative path, or a vector of paths.
}
\description{
Construct a relative path to data files in the \code{bootstrap} data folder,
regardless of whether the current working directory is the TAF root, the
\code{bootstrap} folder, or a subfolder inside \code{bootstrap}.
}
\note{
This function is especially useful in boot scripts.
}
\examples{
taf.data.path()
taf.data.path("example.dat")

}
\seealso{
\link{file.path} is the underlying function used to construct the path.

\code{\link{taf.boot.path}} constructs the path to the \code{bootstrap}
folder.

\code{\link{TAF-package}} gives an overview of the package.
}
