% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_SynthETIC.R
\name{to_SynthETIC}
\alias{to_SynthETIC}
\title{Conversion to SynthETIC Format}
\usage{
to_SynthETIC(x, frequency_vector, level = c("clm", "pmt"), no_payments_list)
}
\arguments{
\item{x}{a vector of simulated quantities for all the claims.}

\item{frequency_vector}{a vector of claim frequencies for all the periods.}

\item{level}{level of the data provided; one of \code{"clm"} (claim, which is the
default) or \code{"pmt"} (payment).}

\item{no_payments_list}{list of number of partial payments; only required
if \code{level = "pmt"}.}
}
\value{
A list of quantities such that the \eqn{i}th component of the
list gives the corresponding measure for all claims that occurred in period
\eqn{i}.
}
\description{
Converts a vector of simulated quantities (e.g. claim occurrence times, claim
sizes) to a list format consistent with what is used for \code{SynthETIC}
simulation; to be used when user wishes to replace one or more of the
\code{SynthETIC} modules with their own.
}
\details{
It is assumed that the simulated quantities in \code{x} is provided in
chronological order, e.g. if there are 30 claims in period 1 and \code{x} is
on a \code{"clm"} level, then the first 30 elements of \code{x} should give the
measures for those 30 claims. Likewise, if \code{x} is on a \code{"pmt"} level, and
the first claim in period 1 has 5 payments, then the first 5 elements of \code{x}
should give the measures for those 5 payments.
}
\examples{
freq <- claim_frequency()
my_claims <- rweibull(sum(freq), shape = 4, scale = 100000)
claim_sizes <- to_SynthETIC(my_claims, freq)
}
