% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/innerAUC_fct.R
\name{innerAUC_fct}
\alias{innerAUC_fct}
\title{Calculates inner and outer survival AUCs of training and testset}
\usage{
innerAUC_fct(f, data, t, cv.out, cv.in, i, fold, data.out, nr.var, out.s, sd1,
  c.time, ranking, used.rank, used.rank1se, pred.in, pred.out, pred.out1,
  auc.out, auc.out1)
}
\arguments{
\item{f}{ranking function}

\item{data}{data input}

\item{t}{current t.times argument}

\item{cv.out}{number of outer CV}

\item{cv.in}{number of inner CV}

\item{i}{current counter index}

\item{fold}{current fold}

\item{data.out}{training data of outer CV}

\item{nr.var}{maximum number of variables into model}

\item{out.s}{predefined output matrix for inner tAUC evaluations}

\item{sd1}{factor to which sparser solutions should be chosen. Not maximum Survival AUC in inner loop is used in stepwise selection, instead \code{max(survAUC)*sd1} leading to sparser solutions}

\item{c.time}{as defined in package \code{survAUC} time; a positive number restricting the upper limit of the time range under consideration.}

\item{ranking}{predefined ranking list}

\item{used.rank}{predefined list}

\item{used.rank1se}{predefined list}

\item{pred.in}{predefined list for inner predictions}

\item{pred.out}{predefined list for outer predictions}

\item{pred.out1}{predefined list for outer predictions with \code{sd1} factor}

\item{auc.out}{vector of survival AUCs}

\item{auc.out1}{vector of survival AUCs with \code{sd1} factor}
}
\description{
work-horse function for all ranking methods with inner and outer CV loops
}
\keyword{internal}

