% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICA_OrdCont_copula.R
\name{compute_ICA_OrdCont}
\alias{compute_ICA_OrdCont}
\title{Compute Individual Causal Association for a given D-vine copula model in the
Ordinal-Continuous Setting}
\usage{
compute_ICA_OrdCont(
  copula_par,
  rotation_par,
  copula_family1,
  copula_family2 = copula_family1,
  n_prec,
  q_S0,
  q_T0,
  q_S1,
  q_T1,
  marginal_sp_rho = TRUE,
  seed = 1,
  ICA_estimator = NULL
)
}
\arguments{
\item{copula_par}{Parameter vector for the sequence of bivariate copulas that
define the D-vine copula. The elements of \code{copula_par} correspond to
\eqn{(c_{12}, c_{23}, c_{34}, c_{13;2}, c_{24;3}, c_{14;23})}.}

\item{rotation_par}{Vector of rotation parameters for the sequence of
bivariate copulas that define the D-vine copula. The elements of
\code{rotation_par} correspond to \eqn{(c_{12}, c_{23}, c_{34}, c_{13;2},
  c_{24;3}, c_{14;23})}.}

\item{copula_family1}{Copula family of \eqn{c_{12}} and \eqn{c_{34}}. For the
possible options, see \code{loglik_copula_scale()}. The elements of
\code{copula_family} correspond to \eqn{(c_{12}, c_{34})}.}

\item{copula_family2}{Copula family of the other bivariate copulas. For the
possible options, see \code{loglik_copula_scale()}. The elements of
\code{copula_family2} correspond to \eqn{(c_{23}, c_{13;2}, c_{24;3}, c_{14;23})}.}

\item{n_prec}{Number of Monte Carlo samples for the computation of the mutual
information.}

\item{q_S0}{Quantile function for the distribution of \eqn{S_0}.}

\item{q_T0}{Quantile function for the distribution of \eqn{T_0}.}

\item{q_S1}{Quantile function for the distribution of \eqn{S_1}.}

\item{q_T1}{Quantile function for the distribution of \eqn{T_1}.}

\item{marginal_sp_rho}{(boolean) Compute the sample Spearman correlation
matrix? Defaults to \code{TRUE}.}

\item{seed}{Seed for Monte Carlo sampling. This seed does not affect the global
environment.}

\item{ICA_estimator}{Function that estimates the ICA between the first two
arguments which are numeric vectors. Defaults to \code{NULL} which corresponds
to using \code{\link[=estimate_ICA_OrdCont]{estimate_ICA_OrdCont()}}.}
}
\value{
(numeric) A Named vector with the following elements:
\itemize{
\item ICA
\item Spearman's rho, \eqn{\rho_s (\Delta S, \Delta T)} (if asked)
\item Marginal association parameters in terms of Spearman's rho (if asked):
\deqn{\rho_{s}(T_0, S_0), \rho_{s}(T_0, S_1), \rho_{s}(T_0, T_1),
 \rho_{s}(S_0, S_1), \rho_{s}(S_0, T_1),
 \rho_{s}(S_1, T_1)}
}
}
\description{
The \code{\link[=compute_ICA_OrdCont]{compute_ICA_OrdCont()}} function computes the individual causal
association for a fully identified D-vine copula model in the setting with a
continuous surrogate endpoint and an ordinal true endpoint.
}
