% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_intervals.R
\name{sensitivity_intervals_Dvine}
\alias{sensitivity_intervals_Dvine}
\title{Compute Sensitivity Intervals}
\usage{
sensitivity_intervals_Dvine(
  fitted_model,
  sens_results,
  measure = "ICA",
  B = 200,
  alpha = 0.05,
  n_prec = 5000,
  mutinfo_estimator = NULL,
  ICA_estimator = NULL,
  restr_time = +Inf,
  ncores = 1
)
}
\arguments{
\item{fitted_model}{Returned value from \code{\link[=fit_model_SurvSurv]{fit_model_SurvSurv()}}. This object
contains the estimated identifiable part of the joint distribution for the
potential outcomes.}

\item{sens_results}{Dataframe returned by
\code{\link[=sensitivity_analysis_SurvSurv_copula]{sensitivity_analysis_SurvSurv_copula()}}. If additional assumptions need to
be incorporated, this dataframe can first be filtered.}

\item{measure}{Compute intervals for which measure of surrogacy? Defaults to
\code{"ICA"}. See first column names of \code{sens_results} for other possibilities.}

\item{B}{Number of bootstrap replications}

\item{alpha}{(numeric) \code{1 - alpha} is the level of the confidence interval}

\item{n_prec}{Number of Monte-Carlo samples for the \emph{numerical approximation}
of the ICA in each replication of the sensitivity analysis.}

\item{mutinfo_estimator}{Function that estimates the mutual information
between the first two arguments which are numeric vectors. Defaults to
\code{FNN::mutinfo()} with default arguments.}

\item{ICA_estimator}{Function that estimates the ICA between the first two
arguments which are numeric vectors. Defaults to \code{NULL} which corresponds
to using \code{\link[=estimate_ICA_ContCont]{estimate_ICA_ContCont()}}, \code{\link[=estimate_ICA_OrdCont]{estimate_ICA_OrdCont()}}, or
\code{\link[=estimate_ICA_OrdOrd]{estimate_ICA_OrdOrd()}} (depending on the endpoint types). This argument is
not used in the survival-survival setting.}

\item{restr_time}{Restriction time for the potential outcomes. Defaults to
\code{+Inf} which means no restriction. Otherwise, the sampled potential outcomes
are replace by \code{pmin(S0, restr_time)} (and similarly for the other potential
outcomes).}

\item{ncores}{Number of cores used in the sensitivity analysis. The
computations are computationally heavy, and this option can speed things up
considerably.}
}
\value{
An S3 object of the class \code{sensitivity_intervals_Dvine} which can be
printed.
}
\description{
\code{\link[=sensitivity_intervals_Dvine]{sensitivity_intervals_Dvine()}} computes the estimated intervals of ignorance
and uncertainty within the information-theoretic causal inference framework
when the data are modeled with a D-vine copula model.
}
\section{Intervals of Ignorance and Uncertainty}{
Vansteelandt et al. (2006) formalized sensitivity analysis for partly
identifiable parameters in the context of missing data and MNAR. These
concepts can be applied to the estimation of the ICA. Indeed, the ICA is also
partly identifiable because 50\% if the potential outcomes are missing.

Vansteelandt et al. (2006) replace a point estimate with a interval estimate:
the estimated interval of ignorance. In addition, they proposed several
extension of the classic confidence interval together with appropriate
definitions of coverage; these are termed intervals of uncertainty.

\code{\link[=sensitivity_intervals_Dvine]{sensitivity_intervals_Dvine()}} implements the estimated interval of
ignorance and the pointwise and strong intervals of uncertainty. Let \eqn{\boldsymbol{\nu}_l}
and \eqn{\boldsymbol{\nu}_u} be the values for the sensitivity parameter that
lead to the lowest and largest ICA, respectively, while fixing the identifiable
parameter at its estimated value \eqn{\hat{\boldsymbol{\beta}}}. See also
\code{\link[=summary_level_bootstrap_ICA]{summary_level_bootstrap_ICA()}}. The following intervals are implemented:
\enumerate{
\item \emph{Estimated interval of ignorance}. This interval is defined as
\eqn{[ICA(\hat{\boldsymbol{\beta}}, \boldsymbol{\nu}_l), ICA(\hat{\boldsymbol{\beta}}, \boldsymbol{\nu}_u)]}.
\item \emph{Pointiwse interval of uncertainty}. Let \eqn{C_l} (and \eqn{C_u}) be the
lower (and upper) limit of a one-sided \eqn{1 - \alpha} CI for
\eqn{ICA(\boldsymbol{\beta_0}, \boldsymbol{\nu}_l)} (and
\eqn{ICA(\boldsymbol{\beta_0}, \boldsymbol{\nu}_l)}). This interval is then
defined as \eqn{[C_l, C_u]} when the ignorance is much larger than the
statistical imprecision.
\item \emph{Strong interval of uncertainty}. Let \eqn{C_l} (and \eqn{C_u}) be the
lower (and upper) limit of a two-sided \eqn{1 - \alpha} CI for
\eqn{ICA(\boldsymbol{\beta_0}, \boldsymbol{\nu}_l)} (and
\eqn{ICA(\boldsymbol{\beta_0}, \boldsymbol{\nu}_l)}). This interval is then
defined as \eqn{[C_l, C_u]}.
}

The CIs, which are need for the intervals of uncertainty, are based on
percentile bootstrap confidence intervals, as documented in
\code{\link[=summary_level_bootstrap_ICA]{summary_level_bootstrap_ICA()}}. In addition, \eqn{\boldsymbol{\nu}_l} is not
known. Therefore, it is estimated as
\deqn{\arg \min_{\boldsymbol{\nu} \in \Gamma} ICA(\hat{\boldsymbol{\beta}}, \boldsymbol{\nu}),}
and similarly for \eqn{\boldsymbol{\nu}_u}.
}

\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Load Ovarian data
data("Ovarian")
# Recode the Ovarian data in the semi-competing risks format.
data_scr = data.frame(
  ttp = Ovarian$Pfs,
  os = Ovarian$Surv,
  treat = Ovarian$Treat,
  ttp_ind = ifelse(
    Ovarian$Pfs == Ovarian$Surv &
      Ovarian$SurvInd == 1,
    0,
    Ovarian$PfsInd
  ),
  os_ind = Ovarian$SurvInd
)
# Fit copula model.
fitted_model = fit_model_SurvSurv(data = data_scr,
                                  copula_family = "clayton",
                                  n_knots = 1)
# Illustration with small number of replications and low precision
sens_results = sensitivity_analysis_SurvSurv_copula(fitted_model,
                  n_sim = 5,
                  n_prec = 2000,
                  copula_family2 = "clayton",
                  eq_cond_association = TRUE)
# Compute intervals of ignorance and uncertainty. Again, the number of
# bootstrap replications should be larger in practice.
sensitivity_intervals_Dvine(fitted_model, sens_results, B = 10)
\dontshow{\}) # examplesIf}
}
\references{
Vansteelandt, Stijn, et al. "Ignorance and uncertainty regions as inferential
tools in a sensitivity analysis." Statistica Sinica (2006): 953-979.
}
