% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copula_utils.R
\name{plot.vine_copula_fit}
\alias{plot.vine_copula_fit}
\title{Goodness-of-fit plots for the fitted copula models}
\usage{
\method{plot}{vine_copula_fit}(x, ...)
}
\arguments{
\item{x}{S3 object returned by \code{\link[=fit_copula_ContCont]{fit_copula_ContCont()}},
\code{\link[=fit_copula_OrdCont]{fit_copula_OrdCont()}}, or \code{\link[=fit_copula_OrdOrd]{fit_copula_OrdOrd()}}.}

\item{...}{Additional parameters. Currently not implemented.}
}
\description{
\code{\link[=plot.vine_copula_fit]{plot.vine_copula_fit()}} plots simple goodness-of-fit plots for the vine
copula model fitted with \code{\link[=fit_copula_ContCont]{fit_copula_ContCont()}}, \code{\link[=fit_copula_OrdCont]{fit_copula_OrdCont()}}, and
\code{\link[=fit_copula_OrdOrd]{fit_copula_OrdOrd()}}.
}
\section{Marginal Goodness-of-Fit}{
\subsection{Continuous Endpoints}{

The estimated model-based marginal density for each continuous endpoint is plotted
alongside a histogram based on the observed data.
}

\subsection{Ordinal Endpoints}{

The estimated model-based marginal probabilities for each ordinal endpoint is plotted
alongside the empirical proportions (red). Red whiskers represent the
95\% confidence intervals for the empirical proportions. These are based on
the delta method with the logit transformation for the proportion.
}
}

\section{Goodness-of-Fit of Association Structure}{
\subsection{Ordinal-Ordinal}{

For each possible value for the surrogate, a plot is produced with (i) the
model-based estimated conditional probabilities, \eqn{P(T = t | S)}, and (ii)
the corresponding empirical conditional probabilities (red). Red whiskers
represent the 95\% confidence intervals for these empirical proportions. These
are based on the delta method with the logit transformation for the
proportion.
}

\subsection{Ordinal-Continuous}{

The model-based estimated regression function \eqn{E(T | S = s)} is plotted
alongside a semiparametric estimate using \code{ mgcv::gam(y~s(x), family = stats::quasi())} (red). Dashed lines represent pointwise 95\% confidence
intervals based on the semiparametric estimate. These confidence intervals
are not trustworthy as they are based on a constant variance assumption.
}

\subsection{Continuous-Continuous}{

The model-based estimated regression function \eqn{E(T | S = s)} is plotted
alongside a semiparametric estimate using \code{ mgcv::gam(y~s(x), family = stats::quasi())} (red). Dashed lines represent pointwise 95\% confidence
intervals based on the semiparametric estimate.
}
}

