% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survbin.R
\name{plot.survbin}
\alias{plot.survbin}
\title{Generates a plot of the estimated treatment effects for the surrogate endpoint versus the estimated treatment effects for the true endpoint for an object fitted with the 'survbin()' function.}
\usage{
\method{plot}{survbin}(x, ...)
}
\arguments{
\item{x}{An object of class 'survbin' fitted with the 'survbin()' function.}

\item{...}{...}
}
\value{
A plot of the type ggplot
}
\description{
Generates a plot of the estimated treatment effects for the surrogate endpoint versus the estimated treatment effects for the true endpoint for an object fitted with the 'survbin()' function.
}
\examples{
\dontrun{
data("colorectal")
fit_bin <- survbin(data = colorectal, true = surv, trueind = SURVIND, surrog = responder,
                   trt = TREAT, center = CENTER, trial = TRIAL, patientid = patientid)
plot(fit_bin)
}

}
