% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_twoway_between.R
\name{power_twoway_between}
\alias{power_twoway_between}
\title{Analytic power calculation for two-way between designs.}
\usage{
power_twoway_between(design_result, alpha_level = 0.05)
}
\arguments{
\item{design_result}{Output from the ANOVA_design function}

\item{alpha_level}{Alpha level used to determine statistical significance}
}
\value{
mu = means

sigma = standard deviation

n = sample size

alpha_level = alpha level

Cohen_f_A = Cohen's f for main effect A

Cohen_f_B = Cohen's f for main effect B

Cohen_f_AB = Cohen's f for the A*B interaction

f_2_A = Cohen's f squared for main effect A

f_2_B = Cohen's f squared for main effect B

f_2_AB = Cohen's f squared for A*B interaction

lambda_A = lambda for main effect A

lambda_B = lambda for main effect B

lambda_AB = lambda for A*B interaction

critical_F_A = critical F-value for main effect A

critical_F_B = critical F-value for main effect B

critical_F_AB = critical F-value for A*B interaction

power_A = power for main effect A

power_B = power for main effect B

power_AB = power for A*B interaction

df_A = degrees of freedom for main effect A

df_B = degrees of freedom for main effect B

df_AB = degrees of freedom for A*B interaction

df_error = degrees of freedom for error term

eta_p_2_A = partial eta-squared for main effect A

eta_p_2_B = partial eta-squared for main effect B

eta_p_2_AB = partial eta-squared for A*B interaction

mean_mat = matrix of the means
}
\description{
Analytic power calculation for two-way between designs.
}
\section{References}{

too be added
}

\examples{
design_result <- ANOVA_design(design = "2b*2b", n = 40, mu = c(1, 0, 1, 0),
     sd = 2, labelnames = c("condition", "cheerful", "sad",
     "voice", "human", "robot"))
power_result <- power_twoway_between(design_result, alpha_level = 0.05)
}
