% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL.biglasso.R
\name{SL.biglasso}
\alias{SL.biglasso}
\title{SL wrapper for biglasso}
\usage{
SL.biglasso(Y, X, newX, family, obsWeights, penalty = "lasso",
  alg.logistic = "Newton", screen = "SSR", alpha = 1, nlambda = 100,
  eval.metric = "default", ncores = 1, nfolds = 5, ...)
}
\arguments{
\item{Y}{Outcome variable}

\item{X}{Training dataframe}

\item{newX}{Test dataframe}

\item{family}{Gaussian or binomial}

\item{obsWeights}{Observation-level weights}

\item{penalty}{The penalty to be applied to the model. Either "lasso"
(default), "ridge", or "enet" (elastic net).}

\item{alg.logistic}{The algorithm used in logistic regression. If "Newton"
then the exact hessian is used (default); if "MM" then a
majorization-minimization algorithm is used to set an upper-bound on the
hessian matrix. This can be faster, particularly in data-larger-than-RAM
case.}

\item{screen}{"SSR" (default) is the sequential strong rule; "SEDPP" is the
(sequential) EDPP rule. "SSR-BEDPP", "SSR-Dome", and "SSR-Slores" are our
newly proposed screening rules which combine the strong rule with a safe
rule (BEDPP, Dome test, or Slores rule). Among the three, the first two are
for lasso-penalized linear regression, and the last one is for
lasso-penalized logistic regression. "None" is to not apply a screening
rule.}

\item{alpha}{The elastic-net mixing parameter that controls the relative
contribution from the lasso (l1) and the ridge (l2) penalty.}

\item{nlambda}{The number of lambda values to check.  Default is 100.}

\item{eval.metric}{The evaluation metric for the cross-validated error and
for choosing optimal \code{lambda}. "default" for linear regression is MSE
(mean squared error), for logistic regression is misclassification error.
"MAPE", for linear regression only, is the Mean Absolute Percentage Error.}

\item{ncores}{The number of cores to use for parallel execution across a
cluster created by the \code{parallel} package.}

\item{nfolds}{The number of cross-validation folds.  Default is 5.}

\item{...}{Any additional arguments, not currently used.}
}
\description{
SL wrapper for biglasso
}
\examples{
\dontrun{
data(Boston, package = "MASS")
Y = Boston$medv
# Remove outcome from covariate dataframe.
X = Boston[, -14]

set.seed(1)

# Sample rows to speed up example.
row_subset = sample(nrow(X), 30)

# Subset rows and columns & use only 2 folds to speed up example.
sl = SuperLearner(Y[row_subset], X[row_subset, 1:2, drop = FALSE],
                  family = gaussian(), cvControl = list(V = 2),
                  SL.library = "SL.biglasso")
sl


	# example for predictions on the full dataset
	pred = predict(sl, X)
	summary(pred$pred)
}


}
\references{
Zeng Y, Breheny P (2017). biglasso: Extending Lasso Model Fitting to Big
Data. https://CRAN.R-project.org/package=biglasso.
}
\seealso{
\code{\link{predict.SL.biglasso}} \code{\link[biglasso]{biglasso}}
  \code{\link[biglasso]{cv.biglasso}}
  \code{\link[biglasso]{predict.biglasso}} \code{\link{SL.glmnet}}
}
