% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Snorm-hess.R
\name{Snorm.hess}
\alias{Snorm.hess}
\title{Hessian of the loglikelihood of a multivariate normal with Toeplitz variance matrix.}
\usage{
Snorm.hess(X, mu, acf, dmu, dacf, d2mu, d2acf)
}
\arguments{
\item{X}{A length-\code{N} vector of multivariate normal observations.}

\item{mu}{A scalar or length-\code{N} vector of means.  If missing defaults to the vector of zeros.}

\item{acf}{A \code{Toeplitz} object or length-\code{N} vector containing the first column of the Toeplitz variance matrix.}

\item{dmu}{A length-\code{p} vector or \code{N x p} matrix of partial derivatives of \code{mu} along the columns.  If missing defaults to a matrix of zeros.}

\item{dacf}{An \code{N x p} matrix with the partial derivatives of \code{acf} along the columns.}

\item{d2mu}{A \code{p x p} matrix or \code{N x p x p} array of second partial derivatives of \code{mu}.  If missing defaults to zeros.}

\item{d2acf}{A \code{N x p x p} array of second partial derivatives of \code{acf}.}
}
\value{
The \code{p x p} Hessian matrix of the loglikelihood.
}
\description{
Superfast evaluation of loglikelihood Hessian.
}
\examples{
# two parameter inference
acf.fun <- function(theta) theta[2]^2 * exp(-(1:N-1))
mu.fun <- function(theta) theta[1] * (1:N) + log(theta[2] + 1:N)

# partial derivatives
dacf.fun <- function(theta) {
  cbind(0, 2*theta[2] * exp(-(1:N-1)))
}
dmu.fun <- function(theta) cbind(1:N, 1/(theta[2] + 1:N))

# 2nd order partials
d2acf.fun <- function(theta) {
  H <- array(0, dim = c(N, 2, 2))
  H[,2,2] <- 2*exp(-(1:N-1))
  H
}
d2mu.fun <- function(theta) {
  H <- array(0, dim = c(N, 2, 2))
  H[,2,2] <- -1/(theta[2] + 1:N)^2
  H
}

# generate data
N <- 300
theta <- rexp(2)
X <- rSnorm(n = 1, acf = acf.fun(theta)) + mu.fun(theta)

# likelihood Hessian
Snorm.hess(X = X, mu = mu.fun(theta), acf = acf.fun(theta),
           dmu = dmu.fun(theta), dacf = dacf.fun(theta),
           d2mu = d2mu.fun(theta), d2acf = d2acf.fun(theta))
}
