% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-tree-plot-function.r
\name{plot_tree}
\alias{plot_tree}
\title{Tree plot for subgroup effect size}
\usage{
plot_tree(
  dat,
  covari.sel,
  trt.sel,
  resp.sel,
  outcome.type,
  add.aux.line = FALSE,
  font.size = c(15, 10, 0.5),
  title = NULL,
  lab.y = NULL,
  text.shift = 0.005,
  keep.y.axis = FALSE,
  grid.newpage = TRUE
)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of the two covariates}

\item{trt.sel}{a covariate index specifying the treatment code}

\item{resp.sel}{a covariate index specifying the response variable}

\item{outcome.type}{a string specifying the type of the response variable, it can be "continuous", or "binary" or  "survival".}

\item{add.aux.line}{a logical operator displaying the auxiliary horizontal line for checking heterogeneity in treatment effects if TRUE}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the main title and  the second element
is for the text in the left, right and bottom labels; the third is for the unit labels on the y-axis.}

\item{title}{a string specifying the main title.}

\item{lab.y}{a string specifying the y-axis label}

\item{text.shift}{a numeric indicating the separation of the text in the branches}

\item{keep.y.axis}{a logical indicating whether to keep the y axis fixed across the levels}

\item{grid.newpage}{logical. If TRUE (default), the function calls grid::grid.newpage() to start from an empty page.}
}
\description{
This function produces a tree plot showing the treatment effect size of subgroups defined by the categories of covariates. The left
side shows treatment effect size; the right side indicates what covariate is considered. Each level shows the 95% C.I. of subgroup
effect estimate and subgroup sample sizes (by the width of horizontal violet lines). Each subgroup is further divided into several
subgroups by categories of the covariate on the lower level. The horizontal line corresponding to the overal effect can be added into
each level so as to check homogeneity across subgroup effects with repective to the overall effect. In addition, the function uses log
odd ratio and log hazard ratio for displaying subgroup effect sizes in binary and survival data, respectively.
}
\examples{
library(dplyr)

# Load the data to be used
data(prca)
dat <- prca
dat \%>\%
  mutate(bm = factor(ifelse(bm == 0 , "No", "Yes")),
         hx = factor(ifelse(hx == 0 , "No", "Yes"))) -> dat

## Tree plot with fixed y-axis
plot_tree(dat,
          covari.sel = c(4, 5, 7),
          trt.sel = 3,
          resp.sel = c(1, 2),
          outcome.type = "survival",
          add.aux.line = TRUE,
          font.size = c(12, 8, 0.55),
          title = NULL,
          lab.y = "Effect size (log hazard ratio)",
          keep.y.axis = TRUE)

## Tree plot with free y-axes
plot_tree(dat,
          covari.sel = c(4, 5, 7),
          trt.sel = 3,
          resp.sel = c(1, 2),
          outcome.type = "survival",
          add.aux.line = TRUE,
          font.size = c(12, 8, 0.55),
          title = NULL,
          lab.y = "Effect size (log hazard ratio)",
          keep.y.axis = FALSE)

}
