% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertAxis.R
\name{convertAxis}
\alias{convertAxis}
\title{Converts the axis following a given formula}
\usage{
convertAxis(
  side,
  formula,
  at.maj,
  at.min = NULL,
  labels = at.maj,
  tick.ratio = 0.75,
  line = NA,
  pos = NA,
  font = NA,
  lty = "solid",
  lwd = 1,
  lwd.ticks = lwd,
  col = NULL,
  col.ticks = NULL,
  hadj = NA,
  padj = NA,
  tcl = NA,
  ...
)
}
\arguments{
\item{side}{an integer specifying which side of the plot the axis is
to be drawn on. The axis is placed as follows: 1=below, 2=left, 3=above and
4=right.}

\item{formula}{the formula to be converted. Should be of the form y ~ f(x)}

\item{at.maj}{a vector of the position and labels of the major ticks}

\item{at.min}{a vector of the position of minor ticks}

\item{labels}{his can either be a logical value specifying whether
(numerical) annotations are to be made at the major tickmarks, or a character
or expression vector of labels to be placed at the major tickpoints.}

\item{tick.ratio}{the ratio of minor to major tick size}

\item{line, pos, font, lty, lwd, lwd.ticks, col, col.ticks, hadj, padj, tcl, ...}{see
?axis function help page for these parameters}
}
\description{
Converts the axis following a given formula, and places ticks in
the new axis value
}
\examples{
plot(1,1,type = "n", xlim = c(0,12), axes = FALSE ,xlab = "", ylab = "")

axis(3)

l <- seq_log(10^0,10^12,divide = TRUE)

convertAxis(1,y ~ log10(x),l[[1]],l[[2]])

}
\seealso{
\code{\link{minorAxis}}
}
