% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minorAxis.R
\name{minorAxis}
\alias{minorAxis}
\title{Adds an axis with minor ticks to a plot}
\usage{
minorAxis(side, n = NULL, at.maj = NULL, at.min = NULL, range = NULL,
  tick.ratio = 0.5, labels.maj = TRUE, line = NA, pos = NA,
  outer = FALSE, font = NA, lty = "solid", lwd = 1, lwd.ticks = lwd,
  col = NULL, col.ticks = NULL, hadj = NA, padj = NA, extend = TRUE,
  tcl = NA, ...)
}
\arguments{
\item{side}{an integer (here 1,2,3 or 4) specifying which side of the
plot the axis is to be drawn on. The axis is placed as follows: 1=below,
2=left, 3=above and, 4=right.}

\item{n}{the number of intervals defined by the minor ticks}

\item{at.maj}{the positions at which major tick-marks are to be drawn.
By default (when NULL) tickmark locations are computed, see the "Details"
part in the ?axis help page.}

\item{at.min}{the positions at which minor tick-marks are to be drawn.
This parameter overrides n.}

\item{range}{the range of the axis}

\item{tick.ratio}{ratio of lengths of minor tick marks to major tick
marks. The length of major tick marks is retrieved from par("tcl") unless
specified otherwise.}

\item{labels.maj}{this can either be a logical value specifying
whether (numerical) annotations are to be made at the major tickmarks, or a
character or expression vector of labels to be placed at the major
tickpoints.}

\item{line, pos, outer, font, lty, lwd, lwd.ticks, col, col.ticks, hadj, padj, tcl, ...}{see the ?axis function help page for the other parameters}

\item{extend}{whether to add minor ticks even outside the major ticks
(T) or not (F)}
}
\description{
Adds an axis with minor ticks to a plot, but with the
possibility to have no superposition of minor ticks on major ticks, allowing
to export a clean plot in vector format. It is based on the
minor.tick function in the Hmisc package.
}
\examples{
plot(c(0,1), c(0,1), axes = FALSE, type = "n", xlab = "", ylab = "")

minorAxis(1, n = 10, range = c(0.12,0.61))

minorAxis(3, n = 10, extend=FALSE)
}
\seealso{
Set a plot environment with minorAxis: \code{\link{whiteSet}},
\code{\link{blackSet}} and \code{\link{greySet}}

This function is based on \code{\link{every_nth}}, which suppresses values
every multiple of a given number.
}
