% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dependence.R
\name{plot_dependence}
\alias{plot_dependence}
\title{Partial dependence plots: Single Variable (marginal effect) or heat map (2 to 
3 variables).}
\usage{
plot_dependence(object, vars, grid.data = NULL, grid.thres = ">0",
  estimand = NULL, ...)
}
\arguments{
\item{object}{Fitted PRISM object}

\item{vars}{Variables to visualize (ex: c("var1", "var2", "var3)). If no grid.data 
provided, defaults to using seq(min(var), max(var)) for each continuous variables. 
For categorical, uses all categories.}

\item{grid.data}{Input grid of values for 2-3 covariates (if 3, last variable cannot
be continuous). This is required for type="heatmap". Default=NULL.}

\item{grid.thres}{Threshold for PLE, ex: I(PLE>thres). Used to estimate P(PLE>thres) for
type="heatmap". Default is ">0". Direction can be reversed and can include equality
sign (ex: "<=").}

\item{estimand}{Estimand for which to generate dependendence or heat map plots.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Plot (ggplot2) object
}
\description{
Partial dependence plots: Single Variable (marginal effect) or heat map (2 to 
3 variables).
}
\references{
\itemize{
\item Friedman, J. Greedy function approximation: A gradient boosting machine.
 Annals of statistics (2001): 1189-1232
\item Zhao, Qingyuan, and Trevor Hastie. Causal interpretations of black-box models.
 Journal of Business & Economic Statistics, to appear. (2017).
}
}
