% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_rfsrc.R
\name{ple_rfsrc}
\alias{ple_rfsrc}
\title{Patient-level Estimates: randomForestSRC}
\usage{
ple_rfsrc(Y, A, X, Xtest, ntree = 1000, byTrt = TRUE, upweight = 100,
  min.node.pct = 0.1, family = "gaussian", ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{Xtest}{Test set}

\item{ntree}{Number of trees (default=1000)}

\item{byTrt}{If TRUE, fit treatment-specific rfsrc models. If FALSE, fit a single
rfsrc model with covariate space (X, A, X*A).}

\item{upweight}{Whether to upweight the probability that the treatment variable is
included as a splitting variable (through rfsrc's xvar.wt argument). Default=100 
(other variables receive weight of 1). Only applicable for single rfsrc model 
(byTrt=FALSE).}

\item{min.node.pct}{Minimum sample size in forest nodes (n*min.node.pct)}

\item{family}{Outcome type ("gaussian", "binomial", "survival"), 
default is "gaussian".}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained random forest (rfsrc) model(s).
 \itemize{
  \item mod - trained model(s)
  \item A - treatment variable (training set)
  \item X - covariate space (training set)
}
}
\description{
Uses treatment-specific (or with explicit X*A interactions) random forest models 
(randomForestSRC package) to obtain patient-level estimates. Used for continuous, 
binary, or survival outcomes.
}
\examples{
\donttest{
library(StratifiedMedicine)
## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

# Counter-factual Random Forest (treatment-specific ranger models) #
mod1 = ple_rfsrc(Y, A, X, Xtest=X)

}

}
