% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsDataset.R
\docType{class}
\name{stormsDataset-class}
\alias{stormsDataset-class}
\alias{stormsDataset}
\title{stormsDataset}
\description{
Choose the database to use within the package's functions
}
\details{
The fields input must provide at least 6 mandatory fields (and at most 11) in
order to benefit from all the functionalities of this package:
\itemize{
\item A field \code{names}: which dimension contains the names of storms
in the netcdf database
\item A field \code{seasons}: which dimension contains the cyclonic
seasons of storms in the netcdf database
\item A field \code{isoTime}: which dimension contains the ISO times of
each (3 or 6 hourly) observations for all storms in the database
\item A field \code{lon}: which dimension contains the longitude
coordinates of each observations for all storms in
the netcdf database
\item A field \code{lat}: which dimension contains the latitude
coordinates of each observations for all storms in
the netcdf database
\item A field \code{msw}: which dimension contains the maximum sustained
wind speed of each observations for all storms in the netcdf
database
}
The following fields are optional but highly recommended:
\itemize{
\item A field \code{basin}: which dimension contains the basin location of
storms in the netcdf database. Used to filter the storms in the netcdf
database
\item A field \code{rmw}: which dimension contains the radius of maximum
wind speed of each observations for all storms in the netcdf
database (See spatialBehaviour, temporalBehaviour)
\item A field \code{sshs}: which dimension contains the Saffir Simpson
Hurricane Scale index of each observations for all storms in the
netcdf database
}
Finally these following fields are optional but mandatory to perform Holland
model (See \code{spatialBehaviour}, \code{temporalBehaviour})
\itemize{
\item A field \code{pressure}: which dimension contains the pressure
in the eye for of each observations for all storms in the netcdf
database
\item A field \code{poci}: which dimension contains the Pressure at the
Outermost Closed Isobar for of each observations for all storms
in the nectdf database
}

Default value is set according to the most relevant dimensions of IBTrACS
databases:
\code{fields = c(basin = "basin", names = "name", seasons = "season", isoTime = "iso_time", lon = "usa_lon", lat = "usa_lat", msw = "usa_wind", rmw = "usa_rmw", pressure = "usa_pres", poci = "usa_poci", sshs = "usa_sshs")}
}
\section{Slots}{

\describe{
\item{\code{filename}}{character. Name of the database to load. Must be a netcdf file}

\item{\code{fields}}{named character vector. Dictionary that provides all the name of
dimensions to extract from the netcdf database (See \code{Details})}

\item{\code{basin}}{character. Basin name to filter the database within its
boundaries. It must be either
\itemize{
\item \code{"NA"}: North Atlantic
\item \code{"SA"}: South Atlantic
\item \code{"EP"}: Eastern North Pacific
\item \code{"WP"}: Western North Pacific
\item \code{"SP"}: South Pacific
\item \code{"SI"}: South India
\item \code{"NI"}: North India
\item \code{"None"}: No particular basin
}}

\item{\code{seasons}}{numeric vector. Range of calendar years to filter storms. For
cyclones that formed in one year and dissipated in the following year, the
latter should be used}

\item{\code{database}}{list of 6 to 10 slots depending on the fields input. Each slot
is either a 1D array of dimension (number of storms) for \code{names} and
\code{seasons} fields, or a 2D array of dimension
(Maximum number of observations:number of storms), for the remaining fields
which are \code{isoTime}, \code{lon}, \code{lat}, \code{msw}, \code{rmw}, \code{pressure}, \code{poci}, \code{sshs}}
}}

