% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_DesMat.R
\name{construct_incompMat}
\alias{construct_incompMat}
\title{Constructs a matrix of 0 and 1 for unobserved and observed cluster periods, respectively.}
\usage{
construct_incompMat(incomplete, dsntype, timepoints, Cl, trtmatrix = NULL)
}
\arguments{
\item{incomplete}{integer, either a scalar (only for SWD) or a matrix.
A vector defines the number of periods before and after the switch from
control to intervention that are observed. A matrix consists of 1's for
observed clusterperiods and 0's for unobserved clusterperiods.}

\item{dsntype}{character, defines the type of design. Options are "SWD",
"parallel" and "parallel_baseline", defaults to "SWD".}

\item{timepoints}{numeric (scalar or vector), number of timepoints (periods).
If design is swd, timepoints defaults to length(Cl)+1.
Defaults to 1 for parallel designs.}

\item{Cl}{integer (vector), number of clusters per sequence group (in SWD),
or number in control and intervention (in parallel designs)}

\item{trtmatrix}{an optional user defined matrix
to define treatment allocation}
}
\value{
a matrix
}
\description{
Mostly useful to build incomplete stepped wedge designs
}
