% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_CovMat.R
\name{construct_CovBlk}
\alias{construct_CovBlk}
\title{Construct a Block of the Covariance Matrix}
\usage{
construct_CovBlk(
  sigma,
  tau,
  eta = NULL,
  tauAR = NULL,
  etaAR = NULL,
  rho = NULL
)
}
\arguments{
\item{sigma}{numeric (vector of length `timepoints`),
residual error}

\item{tau}{numeric (vector of length `timepoints`),
standard deviation of random intercepts}

\item{eta}{numeric (vector of length `timepoints`),
standard deviation of random slope}

\item{tauAR}{numeric (scalar), value between 0 and 1. Defaults to NULL.
If `tauAR` is not NULL, the random intercept `tau` is AR1-correlated.
*Currently not compatible with `rho`!=0 !*}

\item{etaAR}{numeric (scalar), value between 0 and 1. Defaults to NULL.
If `etaAR` is not NULL, the random slope `eta` is AR1-correlated.
*Currently not compatible with `rho`!=0 !*}

\item{rho}{numeric (scalar), correlation of `tau` and `eta`}
}
\value{
a block of a covariance matrix,
corresponding to intra-cluster covariance over time for one cluster
}
\description{
Constructs the covariance matrix
for multiple measurements of the same cluster.
This function is not designed to be used directly.
}
\examples{
construct_CovBlk(sigma=rep(2,5), tau=rep(1,5))
}
