% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.StepReg.R
\name{plot.StepReg}
\alias{plot.StepReg}
\title{Plots from a StepReg object}
\usage{
\method{plot}{StepReg}(x, num_digits = 6, ...)
}
\arguments{
\item{x}{StepReg object}

\item{num_digits}{The number of digits to keep when rounding the results. 
Default is 6.}

\item{...}{Not used}
}
\value{
A list of plots comprising the selection detail plot and selection 
summary plot for each strategy.
}
\description{
plot.StepReg visualizes the variable selection procedure using a StepReg object
}
\examples{
\dontrun{
data(mtcars)
formula <- mpg ~ .
x <- stepwise(formula = formula,
              data = mtcars,
              type = "linear",
              strategy = c("forward","bidirection","backward"),
              metric = c("AIC","BIC","SL"))
plot(x)
}
}
