export.distGUI <-
function()
{
	if(sum(mat.raw$profil[1,])==length(mat.raw$profil[1,]))  
		tkmessageBox(message="No profiles imported")
	else
	{
		tt <- tktoplevel()
		tkwm.title(tt,"Export proximity index")
		
		rb1 <- tkradiobutton(tt)
		rb2 <- tkradiobutton(tt)
		rb3 <- tkradiobutton(tt)
		rb4 <- tkradiobutton(tt)
		rb5 <- tkradiobutton(tt)
		rb6 <- tkradiobutton(tt)
		rb7 <- tkradiobutton(tt)
		rb8 <- tkradiobutton(tt)
		rb9 <- tkradiobutton(tt)
		rb10 <- tkradiobutton(tt)
		rb11 <- tkradiobutton(tt)
		rb12 <- tkradiobutton(tt)
		rb13 <- tkradiobutton(tt)
		rb14 <- tkradiobutton(tt)
		rbValue <- tclVar("euclidean")
		tkconfigure(rb1,variable=rbValue,value="euclidean")
		tkconfigure(rb2,variable=rbValue,value="maximum")
		tkconfigure(rb3,variable=rbValue,value="manhattan")
		tkconfigure(rb4,variable=rbValue,value="canberra")
		tkconfigure(rb5,variable=rbValue,value="minkowski")
		tkconfigure(rb6,variable=rbValue,value="Pearson")
		tkconfigure(rb7,variable=rbValue,value="bray/curtis")
		tkconfigure(rb8,variable=rbValue,value="chisq")
		tkconfigure(rb9,variable=rbValue,value="ruzicka")
		tkconfigure(rb10,variable=rbValue,value="roberts")
		tkconfigure(rb11,variable=rbValue,value="jaccard")
		tkconfigure(rb12,variable=rbValue,value="sorensen")
		tkconfigure(rb13,variable=rbValue,value="ochiai")
		tkconfigure(rb14,variable=rbValue,value="steinhaus")
		
		tkgrid(tklabel(tt,text="      Which proximity matrix to export ?           "))
		tkgrid(tklabel(tt,text="euclidean"),rb1)
		tkgrid(tklabel(tt,text="maximum"),rb2)
		tkgrid(tklabel(tt,text="manhattan"),rb3)
		tkgrid(tklabel(tt,text="canberra"),rb4)
		tkgrid(tklabel(tt,text="minkowski"),rb5)
		tkgrid(tklabel(tt,text="Pearson"),rb6)
		tkgrid(tklabel(tt,text="bray/curtis"),rb7)
		tkgrid(tklabel(tt,text="chisq"),rb8)
		tkgrid(tklabel(tt,text="ruzicka"),rb9)
		tkgrid(tklabel(tt,text="roberts"),rb10)
		tkgrid(tklabel(tt,text="jaccard"),rb11)
		tkgrid(tklabel(tt,text="sorensen"),rb12)
		tkgrid(tklabel(tt,text="ochiai"),rb13)
		tkgrid(tklabel(tt,text="steinhaus"),rb14)
		
		OnOK <- function()
		{
			rbVal <- as.character(tclvalue(rbValue))
			tkdestroy(tt)
			if (rbVal=="euclidean") export.prox.matrix<-as.matrix(dist(mat.analyse, method="euclidean"))
			if (rbVal=="maximum") export.prox.matrix<-as.matrix(dist(mat.analyse, method="maximum"))
			if (rbVal=="manhattan") export.prox.matrix<-as.matrix(dist(mat.analyse, method="manhattan"))
			if (rbVal=="canberra") export.prox.matrix<-as.matrix(dist(mat.analyse, method="canberra"))
			if (rbVal=="minkowski") export.prox.matrix<-as.matrix(dist(mat.analyse, method="minkowski"))
			if (rbVal=="Pearson") export.prox.matrix<-as.matrix(as.dist(1-abs(cor(t(mat.analyse)))))
			if (rbVal=="bray/curtis") export.prox.matrix<-as.matrix(dsvdis(mat.analyse, index="bray/curtis"))
			if (rbVal=="chisq") export.prox.matrix<-as.matrix(dsvdis(mat.analyse, index="chisq"))
			if (rbVal=="ruzicka") export.prox.matrix<-as.matrix(dsvdis(mat.analyse, index="ruzicka"))
			if (rbVal=="roberts") export.prox.matrix<-as.matrix(dsvdist(mat.analyse, index="roberts"))
			if (rbVal=="jaccard") export.prox.matrix<-as.matrix(vegdist(mat.binary, method="jaccard"))
			if (rbVal=="sorensen") export.prox.matrix<-as.matrix(dsvdis(mat.binary, index="sorensen"))
			if (rbVal=="ochiai") export.prox.matrix<-as.matrix(dsvdis(mat.binary, index="ochiai"))
			if (rbVal=="steinhaus") export.prox.matrix<-as.matrix(dsvdis(mat.binary, index="steinhaus"))
			if (rbVal=="jaccard"  | rbVal=="sorensen" | rbVal=="ochiai" | rbVal=="steinhaus" & sum(mat.binary)==length(mat.binary)) tkmessageBox(message="This index works with presence/absence data. You can either transform your profiles into presence/absence profiles (profile processing menu) or use another index")
			if (rbVal=="jaccard"  | rbVal=="sorensen" | rbVal=="ochiai" | rbVal=="steinhaus" & sum(mat.binary)==length(mat.binary)) stop(message="This index works with presence/absence data. You can either transform your profiles into presence/absence profiles (profile processing menu) or use another index")
			
			fileName<-tclvalue(tkgetSaveFile())
			filename<-paste(fileName,".csv",sep="")
			write.table(export.prox.matrix,file=filename,sep=";",dec=".") 	
			
		}
		OK.but <- tkbutton(tt,text="Export proximity matrix",command=OnOK)
		tkgrid(OK.but)
		tkfocus(tt)
	}
}

