% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internalUtils.R
\name{getMinimalFitStMoMo}
\alias{getMinimalFitStMoMo}
\title{Extract a lighter version of a fitted Stochastic Mortality Model}
\usage{
getMinimalFitStMoMo(object)
}
\arguments{
\item{object}{an object of class \code{"fitStMoMo"} with the fitted 
parameters of a stochastic mortality model.}
}
\value{
A list with class \code{"fitStMoMo"} with components
  
  \item{model}{ The \code{StMoMo} defining the fitted stochastic 
  mortality model.}
  
  \item{ax}{ Vector with the fitted values of the static age function
  \eqn{\alpha_x}. If the model does not have a static age function or 
  failed to fit this is set to \code{NULL}.}
    
  \item{bx}{ Matrix with the values of the period age-modulating functions
  \eqn{\beta_x^{(i)}, i=1, ..., N}. If the \eqn{i}-th age-modulating 
  function is non-parametric (e.g. as in the Lee-Carter model) 
  \code{bx[, i]} contains the estimated values. If the model does not have
  any age-period terms (i.e. \eqn{N=0}) or failed to fit this is set to
  \code{NULL}.}
  
  \item{kt}{ Matrix with the values of the fitted period indexes
  \eqn{\kappa_t^{(i)}, i=1, ..., N}. \code{kt[i, ]} contains the estimated
  values of the \eqn{i}-th period index. If the model does not have any 
  age-period terms (i.e. \eqn{N=0}) or failed to fit this is set to 
  \code{NULL}.}
  
  \item{b0x}{ Vector with the values of the cohort age-modulating function
  \eqn{\beta_x^{(0)}}. If the age-modulating function is non-parametric 
  \code{b0x} contains the estimated values. If the model does not have a 
  cohort effect or failed to fit this is set to \code{NULL}.}
    
  \item{gc}{ Vector with the fitted cohort index \eqn{\gamma_{c}}. If the
  model does not have a cohort effect or failed to fit this is set to 
  \code{NULL}.}
  
  \item{Dxt}{ Matrix of deaths used in the fitting.}
  
  \item{Ext}{ Matrix of exposures used in the fitting.}
  
  \item{oxt}{ Matrix of known offset values used in the fitting.}
  
  \item{wxt}{ Matrix of 0-1 weights used in the fitting.}
  
  \item{ages}{ Vector of ages in the data.}
  
  \item{years}{ Vector of years in the data.}
  
  \item{cohorts}{ Vector of cohorts in the data.}
}
\description{
Obtain a lighter version of a fitted Stochastic Mortality Model
with the essential information for plotting, forecasting, 
and simulation.
}
\keyword{internal}
