% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jSeq.R
\name{jSeq}
\alias{jSeq}
\title{Utility for Creating NMR Multiplets}
\usage{
jSeq(length.out)
}
\arguments{
\item{length.out}{An integer giving the number of peaks in the sequence.}
}
\value{
A vector describing the spacing of the parts of an NMR multiplet in
terms of multiples of the coupling constant, J.
}
\description{
This function creates sequences, centered on zero, which correspond to odd
or even NMR multiplets.  Not intended for direct use. Called by
\code{\link{plotNMRspec}}.
}
\examples{

tmp <- jSeq(5) # a multiplet with an odd number of peaks
tmp
tmp <- jSeq(6) # an even number
tmp

}
\seealso{
\code{\link{plotNMRspec}} which calls this function.
}
\author{
Bryan A. Hanson, DePauw University. \email{hanson@depauw.edu}
}
\keyword{utilities}
