% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reilly.R
\name{rasterReilly}
\alias{rasterReilly}
\title{Create a Raster from a Reilly SpatialPointsDataFrame}
\usage{
rasterReilly(x, mask = NULL)
}
\arguments{
\item{x}{sp object (SpatialPointsDataFrame); output of the \code{reilly} function.}

\item{mask}{sp object (SpatialPolygonsDataFrame); this object is used to clip the raster. (optional)}
}
\value{
Raster of catchment areas values.
The raster uses a RAT (\code{\link{ratify}}) that contains the
correspondance between raster values and catchement areas values. Use \code{
unique(levels(rasterName)[[1]])} to see the correpondance table.
}
\description{
This function creates a raster from a regularly spaced
Reilly SpatialPointsDataFrame (output of the \code{\link{reilly}} function).
}
\examples{
data(spatData)
row.names(spatPts) <- spatPts$CodHop
# Compute Reilly catchment areas from known points (spatPts) on a
# grid defined by its resolution
myreilly <- reilly(knownpts = spatPts, varname = "Capacite",
                   typefct = "exponential", span = 750, beta = 2,
                   resolution = 50, longlat = FALSE, mask = spatMask)
# Create a raster of reilly values
myreillyraster <- rasterReilly(x = myreilly, mask = spatMask)
plot(myreillyraster, col = rainbow(18))
# Correspondance between raster values and reilly areas
head(unique(levels(myreillyraster)[[1]]))
}
\seealso{
\link{reilly}, \link{rasterReilly}, \link{plotReilly}, \link{CreateGrid}, \link{CreateDistMatrix}.
}

