% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\name{merge}
\alias{merge}
\alias{merge,SparkDataFrame,SparkDataFrame-method}
\title{Merges two data frames}
\usage{
merge(x, y, ...)

\S4method{merge}{SparkDataFrame,SparkDataFrame}(
  x,
  y,
  by = intersect(names(x), names(y)),
  by.x = by,
  by.y = by,
  all = FALSE,
  all.x = all,
  all.y = all,
  sort = TRUE,
  suffixes = c("_x", "_y"),
  ...
)
}
\arguments{
\item{x}{the first data frame to be joined.}

\item{y}{the second data frame to be joined.}

\item{...}{additional argument(s) passed to the method.}

\item{by}{a character vector specifying the join columns. If by is not
specified, the common column names in \code{x} and \code{y} will be used.
If by or both by.x and by.y are explicitly set to NULL or of length 0, the Cartesian
Product of x and y will be returned.}

\item{by.x}{a character vector specifying the joining columns for x.}

\item{by.y}{a character vector specifying the joining columns for y.}

\item{all}{a boolean value setting \code{all.x} and \code{all.y}
if any of them are unset.}

\item{all.x}{a boolean value indicating whether all the rows in x should
be including in the join.}

\item{all.y}{a boolean value indicating whether all the rows in y should
be including in the join.}

\item{sort}{a logical argument indicating whether the resulting columns should be sorted.}

\item{suffixes}{a string vector of length 2 used to make colnames of
\code{x} and \code{y} unique.
The first element is appended to each colname of \code{x}.
The second element is appended to each colname of \code{y}.}
}
\description{
Merges two data frames
}
\details{
If all.x and all.y are set to FALSE, a natural join will be returned. If
  all.x is set to TRUE and all.y is set to FALSE, a left outer join will
  be returned. If all.x is set to FALSE and all.y is set to TRUE, a right
  outer join will be returned. If all.x and all.y are set to TRUE, a full
  outer join will be returned.
}
\note{
merge since 1.5.0
}
\examples{
\dontrun{
sparkR.session()
df1 <- read.json(path)
df2 <- read.json(path2)
merge(df1, df2) # Performs an inner join by common columns
merge(df1, df2, by = "col1") # Performs an inner join based on expression
merge(df1, df2, by.x = "col1", by.y = "col2", all.y = TRUE)
merge(df1, df2, by.x = "col1", by.y = "col2", all.x = TRUE)
merge(df1, df2, by.x = "col1", by.y = "col2", all.x = TRUE, all.y = TRUE)
merge(df1, df2, by.x = "col1", by.y = "col2", all = TRUE, sort = FALSE)
merge(df1, df2, by = "col1", all = TRUE, suffixes = c("-X", "-Y"))
merge(df1, df2, by = NULL) # Performs a Cartesian join
}
}
\seealso{
\link{join} \link{crossJoin}

Other SparkDataFrame functions: 
\code{\link{SparkDataFrame-class}},
\code{\link{agg}()},
\code{\link{alias}()},
\code{\link{arrange}()},
\code{\link{as.data.frame}()},
\code{\link{attach,SparkDataFrame-method}},
\code{\link{broadcast}()},
\code{\link{cache}()},
\code{\link{checkpoint}()},
\code{\link{coalesce}()},
\code{\link{collect}()},
\code{\link{colnames}()},
\code{\link{coltypes}()},
\code{\link{createOrReplaceTempView}()},
\code{\link{crossJoin}()},
\code{\link{cube}()},
\code{\link{dapplyCollect}()},
\code{\link{dapply}()},
\code{\link{describe}()},
\code{\link{dim}()},
\code{\link{distinct}()},
\code{\link{dropDuplicates}()},
\code{\link{dropna}()},
\code{\link{drop}()},
\code{\link{dtypes}()},
\code{\link{exceptAll}()},
\code{\link{except}()},
\code{\link{explain}()},
\code{\link{filter}()},
\code{\link{first}()},
\code{\link{gapplyCollect}()},
\code{\link{gapply}()},
\code{\link{getNumPartitions}()},
\code{\link{group_by}()},
\code{\link{head}()},
\code{\link{hint}()},
\code{\link{histogram}()},
\code{\link{insertInto}()},
\code{\link{intersectAll}()},
\code{\link{intersect}()},
\code{\link{isLocal}()},
\code{\link{isStreaming}()},
\code{\link{join}()},
\code{\link{limit}()},
\code{\link{localCheckpoint}()},
\code{\link{mutate}()},
\code{\link{ncol}()},
\code{\link{nrow}()},
\code{\link{persist}()},
\code{\link{printSchema}()},
\code{\link{randomSplit}()},
\code{\link{rbind}()},
\code{\link{rename}()},
\code{\link{repartitionByRange}()},
\code{\link{repartition}()},
\code{\link{rollup}()},
\code{\link{sample}()},
\code{\link{saveAsTable}()},
\code{\link{schema}()},
\code{\link{selectExpr}()},
\code{\link{select}()},
\code{\link{showDF}()},
\code{\link{show}()},
\code{\link{storageLevel}()},
\code{\link{str}()},
\code{\link{subset}()},
\code{\link{summary}()},
\code{\link{take}()},
\code{\link{toJSON}()},
\code{\link{unionAll}()},
\code{\link{unionByName}()},
\code{\link{union}()},
\code{\link{unpersist}()},
\code{\link{withColumn}()},
\code{\link{withWatermark}()},
\code{\link{with}()},
\code{\link{write.df}()},
\code{\link{write.jdbc}()},
\code{\link{write.json}()},
\code{\link{write.orc}()},
\code{\link{write.parquet}()},
\code{\link{write.stream}()},
\code{\link{write.text}()}
}
\concept{SparkDataFrame functions}
