% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/column.R
\docType{methods}
\name{\%<=>\%}
\alias{\%<=>\%}
\alias{\%<=>\%}
\alias{\%<=>\%,Column-method}
\title{\%<=>\%}
\usage{
x \%<=>\% value

\S4method{\%<=>\%}{Column}(x, value)
}
\arguments{
\item{x}{a Column}

\item{value}{a value to compare}
}
\description{
Equality test that is safe for null values.
}
\details{
Can be used, unlike standard equality operator, to perform null-safe joins.
Equivalent to Scala \code{Column.<=>} and \code{Column.eqNullSafe}.
}
\note{
\%<=>\% since 2.3.0
}
\examples{
\dontrun{
df1 <- createDataFrame(data.frame(
  x = c(1, NA, 3, NA), y = c(2, 6, 3, NA)
))

head(select(df1, df1$x == df1$y, df1$x \%<=>\% df1$y))

df2 <- createDataFrame(data.frame(y = c(3, NA)))
count(join(df1, df2, df1$y == df2$y))

count(join(df1, df2, df1$y \%<=>\% df2$y))
}
}
