% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{window}
\alias{window}
\alias{window}
\alias{window,Column-method}
\title{window}
\usage{
window(x, ...)

\S4method{window}{Column}(x, windowDuration, slideDuration = NULL,
  startTime = NULL)
}
\arguments{
\item{x}{a time Column. Must be of TimestampType.}

\item{...}{further arguments to be passed to or from other methods.}

\item{windowDuration}{a string specifying the width of the window, e.g. '1 second',
'1 day 12 hours', '2 minutes'. Valid interval strings are 'week',
'day', 'hour', 'minute', 'second', 'millisecond', 'microsecond'. Note that
the duration is a fixed length of time, and does not vary over time
according to a calendar. For example, '1 day' always means 86,400,000
milliseconds, not a calendar day.}

\item{slideDuration}{a string specifying the sliding interval of the window. Same format as
\code{windowDuration}. A new window will be generated every
\code{slideDuration}. Must be less than or equal to
the \code{windowDuration}. This duration is likewise absolute, and does not
vary according to a calendar.}

\item{startTime}{the offset with respect to 1970-01-01 00:00:00 UTC with which to start
window intervals. For example, in order to have hourly tumbling windows
that start 15 minutes past the hour, e.g. 12:15-13:15, 13:15-14:15... provide
\code{startTime} as \code{"15 minutes"}.}
}
\value{
An output column of struct called 'window' by default with the nested columns 'start'
        and 'end'.
}
\description{
Bucketize rows into one or more time windows given a timestamp specifying column. Window
starts are inclusive but the window ends are exclusive, e.g. 12:05 will be in the window
[12:05,12:10) but not in [12:00,12:05). Windows can support microsecond precision. Windows in
the order of months are not supported.
}
\note{
window since 2.0.0
}
\examples{
\dontrun{
  # One minute windows every 15 seconds 10 seconds after the minute, e.g. 09:00:10-09:01:10,
  # 09:00:25-09:01:25, 09:00:40-09:01:40, ...
  window(df$time, "1 minute", "15 seconds", "10 seconds")

  # One minute tumbling windows 15 seconds after the minute, e.g. 09:00:15-09:01:15,
   # 09:01:15-09:02:15...
  window(df$time, "1 minute", startTime = "15 seconds")

  # Thirty-second windows every 10 seconds, e.g. 09:00:00-09:00:30, 09:00:10-09:00:40, ...
  window(df$time, "30 seconds", "10 seconds")
}
}
\seealso{
Other datetime_funcs: \code{\link{add_months}},
  \code{\link{date_add}}, \code{\link{date_format}},
  \code{\link{date_sub}}, \code{\link{datediff}},
  \code{\link{dayofmonth}}, \code{\link{dayofyear}},
  \code{\link{from_unixtime}},
  \code{\link{from_utc_timestamp}}, \code{\link{hour}},
  \code{\link{last_day}}, \code{\link{minute}},
  \code{\link{months_between}}, \code{\link{month}},
  \code{\link{next_day}}, \code{\link{quarter}},
  \code{\link{second}}, \code{\link{to_date}},
  \code{\link{to_utc_timestamp}},
  \code{\link{unix_timestamp}}, \code{\link{weekofyear}},
  \code{\link{year}}
}
