% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R, R/stats.R
\docType{methods}
\name{cov}
\alias{cov}
\alias{covar_samp}
\alias{cov}
\alias{cov,characterOrColumn-method}
\alias{covar_samp}
\alias{covar_samp,characterOrColumn,characterOrColumn-method}
\alias{cov}
\alias{cov,SparkDataFrame-method}
\title{cov}
\usage{
cov(x, ...)

covar_samp(col1, col2)

\S4method{cov}{characterOrColumn}(x, col2)

\S4method{covar_samp}{characterOrColumn,characterOrColumn}(col1, col2)

\S4method{cov}{SparkDataFrame}(x, colName1, colName2)
}
\arguments{
\item{x}{a Column or a SparkDataFrame.}

\item{...}{additional argument(s). If \code{x} is a Column, a Column
should be provided. If \code{x} is a SparkDataFrame, two column names should
be provided.}

\item{col1}{the first Column.}

\item{col2}{the second Column.}

\item{colName1}{the name of the first column}

\item{colName2}{the name of the second column}
}
\value{
The covariance of the two columns.
}
\description{
Compute the sample covariance between two expressions.

Calculate the sample covariance of two numerical columns of a SparkDataFrame.
}
\note{
cov since 1.6.0

covar_samp since 2.0.0

cov since 1.6.0
}
\examples{
\dontrun{
cov(df$c, df$d)
cov("c", "d")
covar_samp(df$c, df$d)
covar_samp("c", "d")
}
\dontrun{
df <- read.json("/path/to/file.json")
cov <- cov(df, "title", "gender")
}
}
\seealso{
Other math_funcs: \code{\link{acos}}, \code{\link{asin}},
  \code{\link{atan2}}, \code{\link{atan}},
  \code{\link{bin}}, \code{\link{bround}},
  \code{\link{cbrt}}, \code{\link{ceil}},
  \code{\link{conv}}, \code{\link{corr}},
  \code{\link{cosh}}, \code{\link{cos}},
  \code{\link{covar_pop}}, \code{\link{expm1}},
  \code{\link{exp}}, \code{\link{factorial}},
  \code{\link{floor}}, \code{\link{hex}},
  \code{\link{hypot}}, \code{\link{log10}},
  \code{\link{log1p}}, \code{\link{log2}},
  \code{\link{log}}, \code{\link{pmod}},
  \code{\link{rint}}, \code{\link{round}},
  \code{\link{shiftLeft}},
  \code{\link{shiftRightUnsigned}},
  \code{\link{shiftRight}}, \code{\link{signum}},
  \code{\link{sinh}}, \code{\link{sin}},
  \code{\link{sqrt}}, \code{\link{tanh}},
  \code{\link{tan}}, \code{\link{toDegrees}},
  \code{\link{toRadians}}, \code{\link{unhex}}

Other stat functions: \code{\link{approxQuantile}},
  \code{\link{corr}}, \code{\link{crosstab}},
  \code{\link{freqItems}}, \code{\link{sampleBy}}
}
