% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\docType{methods}
\name{attach}
\alias{attach}
\alias{attach,SparkDataFrame-method}
\title{Attach SparkDataFrame to R search path}
\usage{
attach(what, pos = 2L, name = deparse(substitute(what)),
  warn.conflicts = TRUE)

\S4method{attach}{SparkDataFrame}(what, pos = 2,
  name = deparse(substitute(what)), warn.conflicts = TRUE)
}
\arguments{
\item{what}{(SparkDataFrame) The SparkDataFrame to attach}

\item{pos}{(integer) Specify position in search() where to attach.}

\item{name}{(character) Name to use for the attached SparkDataFrame. Names
starting with package: are reserved for library.}

\item{warn.conflicts}{(logical) If TRUE, warnings are printed about conflicts
from attaching the database, unless that SparkDataFrame contains an object}
}
\description{
The specified SparkDataFrame is attached to the R search path. This means that
the SparkDataFrame is searched by R when evaluating a variable, so columns in
the SparkDataFrame can be accessed by simply giving their names.
}
\note{
attach since 1.6.0
}
\examples{
\dontrun{
attach(irisDf)
summary(Sepal_Width)
}
}
\seealso{
\link{detach}

Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{arrange}},
  \code{\link{as.data.frame}}, \code{\link{cache}},
  \code{\link{coalesce}}, \code{\link{collect}},
  \code{\link{colnames}}, \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{dapplyCollect}},
  \code{\link{dapply}}, \code{\link{describe}},
  \code{\link{dim}}, \code{\link{distinct}},
  \code{\link{dropDuplicates}}, \code{\link{dropna}},
  \code{\link{drop}}, \code{\link{dtypes}},
  \code{\link{except}}, \code{\link{explain}},
  \code{\link{filter}}, \code{\link{first}},
  \code{\link{gapplyCollect}}, \code{\link{gapply}},
  \code{\link{getNumPartitions}}, \code{\link{group_by}},
  \code{\link{head}}, \code{\link{histogram}},
  \code{\link{insertInto}}, \code{\link{intersect}},
  \code{\link{isLocal}}, \code{\link{join}},
  \code{\link{limit}}, \code{\link{merge}},
  \code{\link{mutate}}, \code{\link{ncol}},
  \code{\link{nrow}}, \code{\link{persist}},
  \code{\link{printSchema}}, \code{\link{randomSplit}},
  \code{\link{rbind}}, \code{\link{registerTempTable}},
  \code{\link{rename}}, \code{\link{repartition}},
  \code{\link{sample}}, \code{\link{saveAsTable}},
  \code{\link{schema}}, \code{\link{selectExpr}},
  \code{\link{select}}, \code{\link{showDF}},
  \code{\link{show}}, \code{\link{storageLevel}},
  \code{\link{str}}, \code{\link{subset}},
  \code{\link{take}}, \code{\link{union}},
  \code{\link{unpersist}}, \code{\link{withColumn}},
  \code{\link{with}}, \code{\link{write.df}},
  \code{\link{write.jdbc}}, \code{\link{write.json}},
  \code{\link{write.orc}}, \code{\link{write.parquet}},
  \code{\link{write.text}}
}
