% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shine.R
\docType{methods}
\name{shine}
\alias{shine}
\alias{shine,simList-method}
\title{Display a simple, interactive shiny app of the simList}
\usage{
shine(sim, title = "SpaDES App", debug = FALSE, filesOnly = FALSE, ...)

\S4method{shine}{simList}(sim, title = "SpaDES App", debug = FALSE,
  filesOnly = FALSE, ...)
}
\arguments{
\item{sim}{a simList object}

\item{title}{character string. The title of the shiny page.}

\item{debug}{Logical. If TRUE, then will show spades event debugger in
console.}

\item{filesOnly}{Logical. If TRUE, then the server.R, ui.R files will be written
to a temp location, with a message indicating where they are.
Publishing this to shinyapps.io is currently very buggy,
and will likely not work as desired.}

\item{...}{additional arguments. Currently not used}
}
\description{
Currently, this is quite simple. It creates a side bar with the simulation
times, plus a set of tabs, one for each module, with numeric sliders.
Currently, this does not treat NAs correctly. Also, it is slow (shiny is not
built to be fast out of the box). There are two
buttons, one to run the entire spades call, the other to do just one time
step at a time. It can be repeatedly pressed.
}
\note{
Many module parameters are only accessed by modules at the start of a
  model run. So, even if the user changes them mid run, there won't be an
  effect on the model runs until \code{Reset} is pressed, and one of the Run
  buttons is pressed.

\code{.plotInterval} changes will only affect plots that are the base
  layer of a given plot image. If there are layers on top of a base layer
  (e.g., an agent on top of a raster layer), the .plotInterval of the
  overlayed layers is ignored.
}
\examples{
\dontrun{
 mySim <- simInit(
   times <- list(start = 0.0, end = 20.0),
   params = list(
     .globals = list(stackName = "landscape", burnStats = "nPixelsBurned")
   ),
   modules = list("randomLandscapes", "fireSpread", "caribouMovement"),
   paths = list(modulePath = system.file("sampleModules", package = "SpaDES"))
 )

shine(mySim)

# To publish to shinyapps.io, need files. THis is not reliable yet.
shine(mySim, filesOnly = TRUE)

# if the user wants to see the events go by, which can help with debugging:
shine(mySim, debug = TRUE)
}
}

