% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability.R
\docType{methods}
\name{dwrpnorm2}
\alias{dwrpnorm2}
\title{Vectorized wrapped normal density function}
\usage{
dwrpnorm2(theta, mu, rho, sd = 1, acc = 1e-05, tol = acc)
}
\arguments{
\item{theta}{value at which to evaluate the density function, measured in radians.}

\item{mu}{mean direction of distribution, measured in radians.}

\item{rho}{mean resultant length of distribution.}

\item{sd}{different way of select \code{rho}, see details below.}

\item{acc}{parameter defining the accuracy of the estimation of the
  density.  Terms are added to the infinite summation that defines the
  density function until successive estimates are within \code{acc} of each
  other.}

\item{tol}{the same as \code{acc}.}
}
\description{
This is a modified version of \code{\link{dwrpnorm}} found in \code{CircStats}
 to allow for multiple angles at once (i.e., vectorized).
}
\examples{
# Values for which to evaluate density
theta <- c(1:500)*2*pi/500
# Compute wrapped normal density function
density <- c(1:500)
for(i in 1:500) density[i] <- dwrpnorm2(theta[i], pi, .75)
plot(theta, density)
# Approximate area under density curve
sum(density*2*pi/500)

}
\author{
Eliot McIntire
}

