% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\docType{methods}
\name{gaussMap}
\alias{gaussMap}
\title{Produce a \code{raster} of a random Gaussian process.}
\usage{
gaussMap(x, scale = 10, var = 1, speedup = 10, inMemory = FALSE, ...)
}
\arguments{
\item{x}{A spatial object (e.g., a \code{RasterLayer}).}

\item{scale}{The spatial scale in map units of the Gaussian pattern.}

\item{var}{Spatial variance.}

\item{speedup}{An index of how much faster than normal to generate maps.}

\item{inMemory}{Should the RasterLayer be forced to be in memory?
Default \code{FALSE}.}

\item{...}{Additional arguments to \code{raster}.}
}
\value{
A raster map of extent \code{ext} with a Gaussian random pattern.
}
\description{
This is a wrapper for the \code{RFsimulate} function in the RandomFields
package. The main addition is the \code{speedup} argument which allows
for faster map generation. A \code{speedup} of 1 is normal and will get
progressively faster as the number increases, at the expense of coarser
pixel resolution of the pattern generated
}
\examples{
\dontrun{
library(RandomFields)
library(raster)
nx <- ny <- 100L
r <- raster(nrows=ny, ncols=nx, xmn=-nx/2, xmx=nx/2, ymn=-ny/2, ymx=ny/2)
speedup <- max(1, nx/5e2)
map1 <- gaussMap(r, scale=300, var=0.03, speedup=speedup, inMemory=TRUE)
Plot(map1)
}

}
\seealso{
\code{\link{RFsimulate}} and \code{\link{extent}}
}

