% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitRaster.R
\docType{methods}
\name{splitRaster}
\alias{splitRaster}
\alias{splitRaster,RasterLayer,integer,integer-method}
\alias{splitRaster,RasterLayer,numeric,numeric-method}
\title{Split a raster into multiple tiles.}
\usage{
splitRaster(x, nx, ny)

\S4method{splitRaster}{RasterLayer,integer,integer}(x, nx, ny)

\S4method{splitRaster}{RasterLayer,numeric,numeric}(x, nx, ny)
}
\arguments{
\item{x}{The raster to be split.}

\item{nx}{The number of tiles to make along the x-axis.}

\item{ny}{The number of tiles to make along the y-axis.}
}
\value{
A list of cropped raster tiles.
}
\description{
Divides up a raster into an arbitrary number of pieces.
Split rasters can be recombined using \code{do.call(merge, x)}.
}
\examples{
require(raster)
# an example with dimensions:
# nrow = 77
# ncol = 101
# nlayers = 3
b <- brick(system.file("external/rlogo.grd", package = "raster"))
r <- b[[1]] # use first layer only
nx <- 3
ny <- 4
y <- splitRaster(r, nx, ny)

# the original raster:
plot(r) # may require a call to `dev()` if using RStudio

# the split raster:
layout(mat = matrix(seq_len(nx*ny), ncol = nx, nrow = ny))
plotOrder <- c(4,8,12,3,7,11,2,6,10,1,5,9)
invisible(lapply(y[plotOrder], plot))

# can be recombined using `raster::merge`
m <- do.call(merge, y)
all.equal(m, r)

}
\author{
Alex Chubaty
}
\seealso{
\code{\link{do.call}}, \code{\link{merge}}.
}

