% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-dependencies-methods.R
\docType{methods}
\name{.depsLoadOrder}
\alias{.depsLoadOrder}
\alias{.depsLoadOrder,simList,igraph-method}
\title{Determine module load order}
\usage{
.depsLoadOrder(sim, simGraph)

\S4method{.depsLoadOrder}{simList,igraph}(sim, simGraph)
}
\arguments{
\item{sim}{A \code{simList} object.}

\item{simGraph}{An \code{\link{igraph}} object produced by \code{\link{depsGraph}}.}
}
\value{
Character vector of module names, sorted in correct load order.
}
\description{
Internal function.
Checks module dependencies and attempts to ensure that cyclic dependencies
can be resolved, checking objects in the global environment, and finally,
attempts to determine the load order for modules in the simulation.
}
\details{
Uses \code{\link[igraph]{topo_sort}} to try to find a load order satisfying
all module object dependencies.
}
\author{
Alex Chubaty
}

