% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\docType{methods}
\name{randomPolygons}
\alias{randomPolygons}
\alias{randomPolygon}
\alias{randomPolygon.SpatialPoints}
\alias{randomPolygon.matrix}
\alias{randomPolygon.SpatialPolygons}
\title{Produce a \code{RasterLayer} of  random polygons}
\usage{
randomPolygons(
  ras = raster(extent(0, 15, 0, 15), res = 1, vals = 0),
  numTypes = 2,
  ...
)

randomPolygon(x, hectares, area)

\method{randomPolygon}{SpatialPoints}(x, hectares, area)

\method{randomPolygon}{matrix}(x, hectares, area)

\method{randomPolygon}{SpatialPolygons}(x, hectares, area)
}
\arguments{
\item{ras}{A raster that whose extent will be used for the random polygons.}

\item{numTypes}{Numeric value. The number of unique polygon types to use.}

\item{...}{Other arguments passed to \code{spread}. No known uses currently.}

\item{x}{Either a \code{SpatialPoints}, \code{SpatialPolygons}, or \code{matrix} with two
dimensions, 1 row, with the approximate centre of the new random polygon to create.
If \code{matrix}, then longitude and latitude are assumed (epsg:4326)}

\item{hectares}{Deprecated. Use \code{area} in meters squared.}

\item{area}{A numeric, the approximate area in \code{meters squared} of the random polygon.}
}
\value{
A map of extent \code{ext} with random polygons.

A \code{SpatialPolygons} object, with approximately the area request,
        centred approximately at the coordinates requested, in the projection of \code{x}
}
\description{
These are built with the \code{\link{spread}} function internally.

Produces a \code{SpatialPolygons} object with 1 feature that will have approximately an area
equal to \code{area} (expecting area in hectares), #' and a centre at approximately \code{x}.
}
\examples{
library(quickPlot)

set.seed(1234)
Ras <- randomPolygons(numTypes = 5)
if (interactive()) {
  clearPlot()
  Plot(Ras, cols = c("yellow", "dark green", "blue", "dark red"))
}

library(raster)
# more complex patterning, with a range of patch sizes
a <- randomPolygons(numTypes = 400, raster(extent(0, 50, 0, 50), res = 1, vals = 0))
a[a < 320] <- 0
a[a >= 320] <- 1
suppressWarnings(clumped <- clump(a)) # warning sometimes occurs, but not important
aHist <- hist(table(getValues(clumped)), plot = FALSE)
if (interactive()) {
  clearPlot()
  Plot(a)
  Plot(aHist)
}

library(raster)
b <- SpatialPoints(cbind(-110, 59))
crs(b) <- sp::CRS("+init=epsg:4326")
a <- randomPolygon(b, area = 1e6)
if (interactive()) {
  plot(a)
  points(b, pch = 19)
}

}
\seealso{
\code{\link{spread}}, \code{\link{raster}}, \code{\link{randomPolygons}}

\code{\link{gaussMap}} and \code{\link{randomPolygons}}
}
