% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/distanceFromEachPoint.R
\name{pointDistance2}
\alias{pointDistance2}
\alias{pointDistance3}
\alias{.pointDistance}
\alias{pointDistance}
\title{Point distance with C++}
\usage{
pointDistance2(to, from)

pointDistance3(fromX, toX, fromY, toY, maxDistance)

.pointDistance(
  from,
  to,
  angles = NA,
  maxDistance = NA_real_,
  otherFromCols = FALSE
)
}
\arguments{
\item{to}{Numeric matrix with 2  or 3 columns (or optionally more, all of which
will be returned),
x and y, representing x and y coordinates of "to" cells, and
optional "id" which will be matched with "id" from \code{from}. Default is all cells.}

\item{from}{Numeric matrix with 2 or 3 or more columns. They must include x and y,
representing x and y coordinates of "from" cell. If there is a column
named "id", it will be "id" from \code{to}, i.e,. specific pair distances.
All other columns will be included in the return value of the function.}

\item{fromX}{Numeric vector of x coordinates for 'from' points}

\item{toX}{Numeric vector of x coordinates for 'to' points}

\item{fromY}{Numeric vector of y coordinates for 'from' points}

\item{toY}{Numeric vector of y coordinates for 'to' points}

\item{maxDistance}{Numeric scalar. The maximum distance cutoff for returned distances.}

\item{angles}{Logical. If \code{TRUE}, then the function will return angles in radians,
as well as distances.}

\item{otherFromCols}{TODO: description needed}
}
\value{
\code{pointDistance2}: a matrix with all the \code{to} columns plus one extra
\code{dists} column.
\code{pointDistance3}: a matrix with \code{x} and \code{y} columns from
\code{to} plus one extra \code{dists} column.

A matrix with 3 columns, x0, y0 and dists.
}
\description{
\code{pointDistance2} performs Pythagorean Theorem and \code{cbind}s all
columns from \code{to} to new dists column.
It is only defined for one point (\code{from}) to many (\code{to}) points.
\code{pointDistance3} performs Pythagorean Theorem and is to be used internally
within \code{distanceFromEachPoint} as an alternative to \code{.pointDistance},
where it does many points (\code{from}) to many (\code{to}) points, one
\code{from} point at a time. The results are then \code{rbind}ed internally.
It does not \code{cbind} extra columns from \code{to}.
}
\details{
A slightly faster way to calculate distances.
}
