% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\docType{methods}
\name{checkObject}
\alias{checkObject}
\alias{checkObject,simList,missing,Raster,character-method}
\alias{checkObject,simList,missing,ANY,missing-method}
\alias{checkObject,simList,character,missing,missing-method}
\alias{checkObject,simList,character,missing,character-method}
\alias{checkObject,missing,ANY,missing,ANY-method}
\title{Check for existence of object(s) referenced by a \code{objects} slot of a
\code{simList} object}
\usage{
checkObject(sim, name, object, layer, ...)

\S4method{checkObject}{simList,missing,Raster,character}(sim, name, object,
  layer, ...)

\S4method{checkObject}{simList,missing,ANY,missing}(sim, name, object,
  layer, ...)

\S4method{checkObject}{simList,character,missing,missing}(sim, name,
  object, layer, ...)

\S4method{checkObject}{simList,character,missing,character}(sim, name,
  object, layer, ...)

\S4method{checkObject}{missing,ANY,missing,ANY}(sim, name, object, layer,
  ...)
}
\arguments{
\item{sim}{A \code{\link{simList}} object.}

\item{name}{A character string specifying the name of an object to be checked.}

\item{object}{An object. This is mostly used internally, or with layer,
because it will fail if the object does not exist.}

\item{layer}{Character string, specifying a layer name in a Raster, if the
\code{name} is a \code{Raster*} object.}

\item{...}{Additional arguments. Not implemented.}
}
\value{
Invisibly return \code{TRUE} indicating object exists; \code{FALSE} if not.
}
\description{
Check that a named object exists in the provide \code{simList} environment slot,
and optionally has desired attributes.
}
\seealso{
\code{\link{library}}.
}
\author{
Alex Chubaty and Eliot McIntire
}
