% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-methods.R
\docType{methods}
\name{rndstr}
\alias{rndstr}
\alias{rndstr,numeric,numeric,logical-method}
\alias{rndstr,numeric,numeric,missing-method}
\alias{rndstr,numeric,missing,logical-method}
\alias{rndstr,missing,numeric,logical-method}
\alias{rndstr,numeric,missing,missing-method}
\alias{rndstr,missing,numeric,missing-method}
\alias{rndstr,missing,missing,logical-method}
\alias{rndstr,missing,missing,missing-method}
\title{Generate random strings}
\usage{
rndstr(n, len, characterFirst)

\S4method{rndstr}{numeric,numeric,logical}(n, len, characterFirst)

\S4method{rndstr}{numeric,numeric,missing}(n, len)

\S4method{rndstr}{numeric,missing,logical}(n, characterFirst)

\S4method{rndstr}{missing,numeric,logical}(len, characterFirst)

\S4method{rndstr}{numeric,missing,missing}(n)

\S4method{rndstr}{missing,numeric,missing}(len)

\S4method{rndstr}{missing,missing,logical}(characterFirst)

\S4method{rndstr}{missing,missing,missing}(n, len, characterFirst)
}
\arguments{
\item{n}{Number of strings to generate (default 1).
Will attempt to coerce to integer value.}

\item{len}{Length of strings to generate (default 8).
Will attempt to coerce to integer value.}

\item{characterFirst}{Logical, if \code{TRUE}, then a letter will be the
first character of the string (useful if being used for object names).}
}
\value{
Character vector of random strings.
}
\description{
Generate a vector of random alphanumeric strings each of an arbitrary length.
}
\examples{
set.seed(11)
rndstr()
rndstr(len = 10)
rndstr(characterFirst = FALSE)
rndstr(n = 5, len = 10)
rndstr(n = 5)
rndstr(n = 5, characterFirst = TRUE)
rndstr(len = 10, characterFirst = TRUE)
rndstr(n = 5, len = 10, characterFirst = TRUE)

}
\author{
Alex Chubaty and Eliot McIntire
}
