% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{ls.simList}
\alias{ls.simList}
\alias{ls,simList-method}
\alias{objects.simList}
\alias{objects,simList-method}
\title{List simulation objects}
\usage{
ls.simList(name)

\S4method{ls}{simList}(name)

objects.simList(name)

\S4method{objects}{simList}(name)
}
\arguments{
\item{name}{A \code{simList} object.}
}
\description{
Return a vector of character strings giving the names of the objects in the
specified simulation environment.
Can be used with a \code{simList} object, because the method for this class
is simply a wrapper for calling \code{ls} on the simulation environment
stored in the \code{simList} object.
}
\seealso{
Other functions to access elements of a \code{simList} object: \code{\link{.addDepends}},
  \code{\link{doEvent.checkpoint}}, \code{\link{envir}},
  \code{\link{events}}, \code{\link{globals}},
  \code{\link{inputs}}, \code{\link{ls.str.simList}},
  \code{\link{modules}}, \code{\link{objs}},
  \code{\link{packages}}, \code{\link{params}},
  \code{\link{paths}}, \code{\link{progressInterval}},
  \code{\link{times}}
}
\concept{functions to access elements of a \code{simList} object}
