% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation-parseModule.R
\docType{methods}
\name{.parseModulePartial}
\alias{.parseModulePartial}
\alias{.parseModulePartial,missing,missing,character,character-method}
\alias{.parseModulePartial,simList,list,missing,character-method}
\alias{.parseModule}
\alias{.parseModule,simList,list-method}
\title{Parse and initialize a module}
\usage{
.parseModulePartial(sim, modules, filename, defineModuleElement)

\S4method{.parseModulePartial}{missing,missing,character,character}(filename,
  defineModuleElement)

\S4method{.parseModulePartial}{simList,list,missing,character}(sim, modules,
  defineModuleElement)

.parseModule(sim, modules, userSuppliedObjNames = NULL, notOlderThan, ...)

\S4method{.parseModule}{simList,list}(sim, modules,
  userSuppliedObjNames = NULL, notOlderThan, ...)
}
\arguments{
\item{sim}{A \code{simList} simulation object.}

\item{modules}{A list of modules with a logical attribute "parsed".}

\item{filename}{The filename of the module to be parsed.}

\item{defineModuleElement}{Character string indicating which of the list
elements in defineModule should be extracted}

\item{userSuppliedObjNames}{Character string (or \code{NULL}, the default)
indicating the names of objects that user has passed
into simInit via objects or inputs.
If all module inputObject dependencies are provided by user,
then the \code{.inputObjects} code will be skipped.}

\item{notOlderThan}{Passed to \code{Cache} that may be used for .inputObjects function call.}

\item{...}{All \code{simInit} parameters.}
}
\value{
\code{.parseModulePartial} extracts just the individual element
requested from the module. This can be useful if parsing the whole module
would cause an error.

A \code{simList} simulation object.
}
\description{
Internal function, used during \code{\link{simInit}}.
}
\author{
Eliot McIntire

Alex Chubaty and Eliot McIntire
}
\keyword{internal}
