% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moduleMetadata.R
\docType{methods}
\name{moduleVersion}
\alias{moduleVersion}
\alias{moduleVersion,character,character,missing-method}
\alias{moduleVersion,character,missing,missing-method}
\alias{moduleVersion,character,missing,simList-method}
\title{Parse and extract a module's version}
\usage{
moduleVersion(module, path, sim)

\S4method{moduleVersion}{character,character,missing}(module, path)

\S4method{moduleVersion}{character,missing,missing}(module)

\S4method{moduleVersion}{character,missing,simList}(module, sim)
}
\arguments{
\item{module}{Character string. Your module's name.}

\item{path}{Character string specifying the file path to modules directory.
Default is to use the \code{spades.modulePath} option.}

\item{sim}{A \code{simList} simulation object, generally produced by \code{simInit}.}
}
\value{
\code{numeric_version} indicating the module's version.
}
\description{
Parse and extract a module's version
}
\examples{
path <- system.file("sampleModules", package = "SpaDES.core")

# using filepath
moduleVersion("caribouMovement", path)

# using simList
mySim <- simInit(
   times = list(start = 2000.0, end = 2002.0, timeunit = "year"),
   params = list(
     .globals = list(stackName = "landscape", burnStats = "nPixelsBurned")
   ),
   modules = list("randomLandscapes", "fireSpread", "caribouMovement"),
   paths = list(modulePath = path)
)
moduleVersion("caribouMovement", sim = mySim)
}
\seealso{
\code{\link{moduleMetadata}}
}
\author{
Alex Chubaty
}
