# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Base function for computing SpaCC solution for single regularization value.
#' @param X A subject (n) by probe (p) data matrix
#' @param w A vector weights for adjacent probes. Should have length nprobes -1
#' @param gamma A scalar value for the regularization parameter
#' @param nu A scalar value for the step size in AMA algorithm
#' @param verbose Logical value whether progress should be printed
#' @param tol A scalar value for convergence tolerance.
#' @param maxiter Maximum number of iterations
#' @param Uinit A matrix used for warm starts with U
#' @param Vinit A matrix used for warm start with V
#' @param Laminit A matrix used for warm starts with Lam
#' @return An RcppArmadillo field object. Has three components, each holds the U,V, and Lam matrix for the current regularization
#' @export
SpaCC <- function(X, w, gamma, nu, verbose, tol, maxiter, Uinit, Vinit, Laminit) {
    .Call('SpaCCr_SpaCC', PACKAGE = 'SpaCCr', X, w, gamma, nu, verbose, tol, maxiter, Uinit, Vinit, Laminit)
}

