% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{SpaCCI_local}
\alias{SpaCCI_local}
\title{Infer Cell-Cell Interactions on a Local Scale}
\usage{
SpaCCI_local(
  gene_spot_df,
  spot_cell_prop_df,
  spatial_coord,
  prop,
  radius,
  matching_L_R_pairs,
  matching_L_R_pairs_info
)
}
\arguments{
\item{gene_spot_df}{A data frame where the rows are genes and the columns are spots (Spot_IDs), representing gene expression levels across spatial spots.}

\item{spot_cell_prop_df}{A data frame of cell type proportions for each spot. The rows represent spots (Spot_IDs), and the columns represent different cell types.}

\item{spatial_coord}{A data frame of the spatial coordinates. The column names should include `c("Spot_ID", "imagerow", "imagecol")`, and the row names must be the Spot_IDs, which is the same as the row names in the cell type proportion data frame or the column names of the gene*spot expression data frame.}

\item{prop}{A numeric value representing the proportion of spots to randomly sample as center spots for local neighborhood analysis.}

\item{radius}{A numeric value specifying the radius of the spatial neighborhood around each center spot.}

\item{matching_L_R_pairs}{A data frame containing matching ligand-receptor pairs. Each row corresponds to a ligand-receptor pair, with columns for \code{ligand_vector} and \code{receptor_vector}.}

\item{matching_L_R_pairs_info}{A data frame providing additional information for each ligand-receptor pair, such as pathway information.}
}
\value{
A list containing:
\describe{
  \item{dataframelist}{A list of data frames, each representing the inferred interactions for a specific center spot. Each data frame includes information on ligand and receptor cell types, P-values, and adjusted P-values.}
  \item{RegionIDs_matrix}{A list of matrices, each containing the IDs of the spots within the specified radius of each center spot.}
}
}
\description{
This function infers cell-cell interactions on a local scale using spatial transcriptomics data. It utilizes permutation testing to identify significant ligand-receptor interactions within specified neighborhoods around randomly selected center spots.
}
