% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.wave.R
\name{align.wave}
\alias{align.wave}
\title{Automatic placement of calls at beggining of sound window}
\usage{
align.wave(
  wav.at = NULL,
  wav.to = "Aligned",
  time.length = 1,
  time.perc = 0.005,
  dBlevel = 25,
  f = 44100,
  wl = 512,
  ovlp = 70
)
}
\arguments{
\item{wav.at}{filepath to the folder where \code{".wav"} files are stored. Should be presented between quotation marks. By default: \code{wav.at = NULL} (i.e. user must specify the filepath to \code{".wav"} files)}

\item{wav.to}{name of the folder where new \code{".wav"} files will be stored. Should be presented between quotation marks. By default: \code{wav.to = "Aligned"}}

\item{time.length}{intended length for the time (X-axis) in seconds. Should be a value that encompasses all sounds in the study. By default: \code{time.length = 1}}

\item{time.perc}{slight time gap (in percentage) relative to the intended length that encompass all sounds in the study (i.e. \code{time.length}). Intervals are added before and after the minimum and maximum time coordinates (X-values) from the selected curve of relative amplitude (\code{dBlevel}). By default: \code{time.perc = 0.005} (i.e. 0.5\%)}

\item{dBlevel}{absolute amplitude value to be used as relative amplitude contour, which will serve as reference for call placement. By default: \code{dBlevel = 25}}

\item{f}{sampling frequency of \code{".wav"} files (in Hz). By default: \code{f = 44100}}

\item{wl}{length of the window for the analysis. By default: \code{wl = 512}}

\item{ovlp}{overlap between two successive windows (in \%) for increased spectrogram resolution. By default: \code{ovlp = 70}}
}
\description{
Recreate each \code{".wav"} file on a given folder while placing calls at the beggining of sound window. New \code{".wav"} files will be stored on a new folder, which is automatically created.
}
\examples{
\donttest{
library(seewave)
library(tuneR)

# Create temporary folder to store ".wav" files
wav.at <- file.path(base::tempdir(), "align.wave")
if(!dir.exists(wav.at)) dir.create(wav.at)

# Create temporary folder to store results
store.at <- file.path(base::tempdir(), "align.wave-output")
if(!dir.exists(store.at)) dir.create(store.at)

# Select acoustic units to be analyzed
data(cuvieri)
spectro(cuvieri, flim = c(0,3)) # Visualize sound data that will be used

# Cut acoustic units from original Wave
cut.cuvieri1 <- cutw(cuvieri, f=44100, from=0, to=0.5, output = "Wave")
cut.cuvieri2 <- cutw(cuvieri, f=44100, from=0.7, to=1.2, output = "Wave")
cut.cuvieri3 <- cutw(cuvieri, f=44100, from=1.4, to=1.9, output = "Wave")

# Export ".wav" files containing selected acoustic units and store on previosly created folder
writeWave(cut.cuvieri1, filename = file.path(wav.at, "cut.cuvieri1.wav"), extensible = FALSE)
writeWave(cut.cuvieri2, filename = file.path(wav.at, "cut.cuvieri2.wav"), extensible = FALSE)
writeWave(cut.cuvieri3, filename = file.path(wav.at, "cut.cuvieri3.wav"), extensible = FALSE)

# Align acoustic units selected at 1\% of time lenght
align.wave(wav.at = wav.at, wav.to = "Aligned",
           time.length = 0.5, time.perc = 0.01, dBlevel = 25)

# Verify alignment using eigensound function featuring analysis.type = "twoDshape"

}

}
\references{
MacLeod, N., Krieger, J. & Jones, K. E. (2013). Geometric morphometric approaches to acoustic signal analysis in mammalian biology. \emph{Hystrix, the Italian Journal of Mammalogy, 24}(1), 110-125.

Rocha, P. & Romano, P. (\emph{in prep}) The shape of sound: A new \code{R} package that crosses the bridge between Bioacoustics and Geometric Morphometrics. \emph{Methods in Ecology and Evolution}
}
\seealso{
\code{\link{eigensound}}

Useful links:
\itemize{
\item{\url{https://github.com/p-rocha/SoundShape}}
\item{Report bugs at \url{https://github.com/p-rocha/SoundShape/issues}}}
}
\author{
Pedro Rocha
}
