% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-adat.R
\name{write_adat}
\alias{write_adat}
\title{Write an ADAT to File}
\usage{
write_adat(x, file)
}
\arguments{
\item{x}{A \code{soma_adat} object (with intact attributes),
typically created using \code{\link[=read_adat]{read_adat()}}.}

\item{file}{Character. File path where the object should be written.
For example, extensions should be \verb{*.adat}.}
}
\value{
Invisibly returns the input \code{x}.
}
\description{
One can write an existing modified internal ADAT
(\code{soma_adat} R object) to an external file.
However the ADAT object itself \emph{must} have intact
attributes, see \code{\link[=is_intact_attr]{is_intact_attr()}}.
}
\details{
The ADAT specification \emph{no longer} requires Windows
end of line (EOL) characters (\verb{"\r\n"}).
The current EOL spec is \verb{"\n"} which is commonly used in POSIX systems,
like MacOS and Linux.
Since the EOL affects the resulting checksum, ADATs written on
other systems generate slightly differing files.
Standardizing to \verb{"\n"} attempts to solve this issue.
For reference, see the EOL encoding for operating systems below:\cr
\tabular{llc}{
Symbol \tab Platform    \tab Character \cr
LF     \tab Linux       \tab \verb{"\n"} \cr
CR     \tab MacOS       \tab \verb{"\r"} \cr
CRLF   \tab DOS/Windows \tab \verb{"\r\n"}
}
}
\examples{
# trim to 1 sample for speed
adat_out <- head(example_data, 1L)

# attributes must(!) be intact to write
is_intact_attr(adat_out)

write_adat(adat_out, file = tempfile(fileext = ".adat"))
}
\seealso{
\code{\link[=read_adat]{read_adat()}}, \code{\link[=is_intact_attr]{is_intact_attr()}}

Other IO: 
\code{\link{loadAdatsAsList}()},
\code{\link{parseHeader}()},
\code{\link{read_adat}()},
\code{\link{soma_adat}}
}
\author{
Stu Field
}
\concept{IO}
