% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/youth_sojourn_tree.R
\name{youth_sojourn_tree}
\alias{youth_sojourn_tree}
\title{Decision tree for making final predictions in the youth Sojourn method}
\usage{
youth_sojourn_tree(Vector.Magnitude, Block.Est, Sojourns.Est, Hip = TRUE,
  RAW = FALSE, epoch = 1)
}
\arguments{
\item{Vector.Magnitude}{numeric vector of triaxial acceleration (vector
magnitude for activity counts, and Euclidian Norm Minus One for raw
acceleration)}

\item{Block.Est}{predictions obtained from the neural networks using static
segmentation}

\item{Sojourns.Est}{predictions obtained from the neural networks using
dynamic segmentation (i.e., Sojourn-specific predictions)}

\item{Hip}{logical. Are data from a hip-worn device?}

\item{RAW}{logical. Are the data raw acceleration?}

\item{epoch}{numeric. The epoch length of the data. Values other than one are
not recommended.}
}
\value{
A factor vector of predicted physical activity intensities
  (Sedentary, Light, or moderate-to-vigorous physical activity (MVPA))
}
\description{
Decision tree for making final predictions in the youth Sojourn method
}
\keyword{internal}
