% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_AP.R
\name{read_AP}
\alias{read_AP}
\title{Read an activPAL events file}
\usage{
read_AP(filename, tz = "UTC")
}
\arguments{
\item{filename}{character. Path to the file}

\item{tz}{character. The timezone to use}
}
\value{
Data frame reflecting the data contained in \code{filename}.
}
\description{
Read an activPAL events file
}
\note{
There must be a corresponding \code{.def} file located in the same
  directory as \code{filename}
}
\examples{
ap_file <- system.file(
"extdata/sampledata_Events.csv",
package = "Sojourn"
)
ap_data <- read_AP(ap_file)
head(ap_data)
}
