% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4ClassDefinitions.R
\docType{class}
\name{ConstInFluxes-class}
\alias{ConstInFluxes-class}
\title{S4 class for a constant influx vector}
\description{
It is mainly used to dispatch S4-methods for computations that 
are valid only if the influx is constant.
This knowledge can either be used to speed up computations or to decide if they are
possible at all.
E.g. the computation of equilibria for a model run requires autonomy of the model which 
requires the influxes to be time independent. If the model is linear  
and compartmental then the (unique) equilibrium can be computed.
Accordingly a method with ConstInFluxes in the signature can be implemented, whereas 
none would be available for a general InFluxes argument.
}
\section{S4-methods}{
  \subsection{S4-methods with class \code{ConstInFluxes} in their signature:}{
      \itemize{
        \item \code{\link{ConstantInFluxList_by_PoolIndex,ConstInFluxes-method}}
        \item \code{\link{getConstantInFluxVector,ConstInFluxes-method}}
        \item \code{\link{getFunctionDefinition,ConstInFluxes-method}}
        \item \code{\link{getTimeRange,ConstInFluxes-method}}
      }
  }
  \subsection{S4-methods with superclasses (in the package) of class \code{ConstInFluxes} in their signature:}{
    \subsection{superclass InFluxes}{
      \itemize{
        \item \code{\link{InFluxes,InFluxes-method}}
      }
    }
  }
}
\section{S4-superclasses (in the package)}{
      \itemize{
        \item \code{\linkS4class{InFluxes}}
      }
}
