% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/productivity_indicator.R
\name{productivity_indicator}
\alias{productivity_indicator}
\title{Calculate average productivity}
\usage{
productivity_indicator(var_MGMT_data, extended.output = FALSE)
}
\arguments{
\item{var_MGMT_data}{a management_df that contains the management information}

\item{extended.output}{an optional logical value.
\itemize{
\item If FALSE, relative yields are aggregated by year.
\item If TRUE, a tibble with relative yield of each crop is returned.
\item Default value is FALSE
}}
}
\value{
\itemize{
\item By default, a tibble with relative yields by year is returned.
\item If extended.output = TRUE, a tibble with additional information is returned.
}
}
\description{
Estimates estimates the relative yield of a cropping sequence per year.
The function takes a \code{management_df} as input and
returns a \code{relative_yield} value per year in the \code{management_df.}
Alternatively, it can return a tibble with additional information on each crop.
The \code{\link[=productivity_indicator]{productivity_indicator()}} calculates the relative yields
with the \code{\link[=relative_yield]{relative_yield()}} function.
}
\examples{
#example that returns annual relative yield values
productivity_indicator(EXAMPLE_data)

#example that returns a tibble with additional information
productivity_indicator(EXAMPLE_data, extended.output = TRUE)

}
\seealso{
\itemize{
\item \code{\link[=relative_yield]{relative_yield()}} for caluclating relative yields
\item \code{\link[=calculate_indicators]{calculate_indicators()}} for calculating all soil management indicators
}
}
