% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umvueLN.R
\name{umvueLN}
\alias{umvueLN}
\title{Computes UMVUEs of lognormal parameters}
\usage{
umvueLN(x, tol = 1e-15, verbose = FALSE)
}
\arguments{
\item{x}{Vector of lognormal data}

\item{tol}{Tolerence level for convengence of the infinite series, \emph{Psi}. Convergence occurs when the absolute value of the
current term in the series is less than \code{tol}.}

\item{verbose}{Logical indicating whether iteration steps for convergence of \emph{Psi} are printed.}
}
\value{
Returns a named vector with the following components \item{mu}{The
UMVUE of the mean} \item{se.mu}{The UMVUE standard error of the mean}
\item{sigma}{The UMVUE of the standard deviation}
}
\description{
Computes uniformly minimum variance unbiased (UMVU) estimates of the mean,
the standard error of the mean, and
the standard deviation of lognormally distributed data.
}
\details{
Calculates equations 13.3, 13.5, and 13.6 of Gilbert (1987).
}
\examples{

# Test from Gilbert 1987, Example 13.1, p 166
x <- c(3.161, 4.151, 3.756, 2.202, 1.535, 20.76, 8.42, 7.81, 2.72, 4.43)
y <- umvueLN(x)
print(y, digits = 8)

# Compare to results from PRO-UCL 4.00.02:

# MVU Estimate of Mean                     5.6544289
# MVU Estimate of Standard Error of Mean   1.3944504
# MVU Estimate of SD                       4.4486438

# Compare these to Gilbert's printed results (which have rounding error)
Gilbert <- c(5.66, sqrt(1.97), sqrt(19.8))
print(round(abs(y - Gilbert), 2))
}
\author{
Landon Sego
}
\references{
Gilbert, Richard O. (1987) Statistical Methods for
Environmental Pollution Monitoring, John Wiley & Sons, Inc. New York, pp
164-167.
}
\keyword{misc}

